/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.violations.TypeConfig;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsCollector;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsProjectAction;
import hudson.plugins.violations.ViolationsReport;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsPublisher
extends Publisher {
    private static final String VIOLATIONS = "violations";
    private final ViolationsConfig config = new ViolationsConfig();
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    public ViolationsConfig getConfig() {
        return this.config;
    }

    public ViolationsConfig getOldConfig() {
        return this.config.clone();
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath htmlPath = new FilePath(new File(((Project)build.getProject()).getRootDir(), VIOLATIONS));
        FilePath targetPath = new FilePath(new File(build.getRootDir(), VIOLATIONS));
        ViolationsReport report = (ViolationsReport)((Project)build.getProject()).getWorkspace().act((FilePath.FileCallable)new ViolationsCollector(listener, targetPath, htmlPath, this.config));
        report.setConfig(this.config);
        report.setBuild(build);
        build.getActions().add(new ViolationsBuildAction(build, report));
        return true;
    }

    public Action getProjectAction(Project project) {
        return new ViolationsProjectAction(project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        private DescriptorImpl() {
            super(ViolationsPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Report Violations";
        }

        public String getHelpFile() {
            return "/plugin/violations/help.html";
        }

        public Publisher newInstance(StaplerRequest req) {
            ViolationsPublisher pub = new ViolationsPublisher();
            req.bindParameters((Object)pub, "violations.");
            req.bindParameters((Object)pub.getConfig(), "config.");
            for (Map.Entry<String, TypeConfig> entry : pub.getConfig().getTypeConfigs().entrySet()) {
                String type = entry.getKey();
                TypeConfig c = entry.getValue();
                req.bindParameters((Object)c, type + ".");
                if ("".equals(req.getParameter(type + ".min"))) {
                    c.setMin(10);
                }
                if (!"".equals(req.getParameter(type + ".max"))) continue;
                c.setMax(999);
            }
            pub.getConfig().fix();
            return pub;
        }

        public ViolationsConfig getConfig() {
            return new ViolationsConfig();
        }
    }
}

