/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.generate;

import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.generate.Execute;
import hudson.plugins.violations.generate.XMLUtil;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.util.CloseUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class OutputFileModel
implements Execute {
    private static final int NEAR = 10;
    private final FullFileModel fileModel;
    private final ViolationsConfig config;
    private PrintWriter w;
    private BufferedReader sourceReader = null;
    private HashMap<Integer, Set<Violation>> vMap = new HashMap();
    private SortedMap<String, LimitedType> limitedMap = new TreeMap<String, LimitedType>();

    public OutputFileModel(FullFileModel fileModel, ViolationsConfig config) {
        this.fileModel = fileModel;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PrintWriter w) throws IOException {
        this.w = w;
        w.println("<file");
        w.print(" ");
        w.println(XMLUtil.toAttribute("name", this.fileModel.getDisplayName()));
        w.print(" ");
        w.println(XMLUtil.toAttribute("last-modified", "" + this.fileModel.getLastModified()));
        if (this.fileModel.getSourceFile() != null) {
            w.print(" ");
            w.println(XMLUtil.toAttribute("file", this.fileModel.getSourceFile().getAbsolutePath()));
        }
        w.println(">");
        this.createLimited();
        if (this.fileModel.getSourceFile() != null && this.fileModel.getSourceFile().exists()) {
            try {
                this.outputContents();
            }
            finally {
                this.closeSourceFile();
            }
        }
        this.outputSummary();
        w.println("</file>");
    }

    private void addToVMap(Violation v) {
        if (this.vMap.get(v.getLine()) == null) {
            this.vMap.put(v.getLine(), new TreeSet());
        }
        this.vMap.get(v.getLine()).add(v);
    }

    private void createLimited() throws IOException {
        for (Map.Entry e : this.fileModel.getTypeMap().entrySet()) {
            String type = (String)e.getKey();
            Set violations = (Set)e.getValue();
            LimitedType limitedType = new LimitedType();
            limitedType.number = violations.size();
            int c = 0;
            for (Violation v : violations) {
                limitedType.violations.add(v);
                this.addToVMap(v);
                this.doViolation(v);
                if (++c < this.config.getLimit()) continue;
                break;
            }
            this.limitedMap.put(type, limitedType);
        }
    }

    private void closeSourceFile() {
        CloseUtil.close(this.sourceReader);
        this.sourceReader = null;
    }

    private boolean near(int lineNumber) {
        for (int i = lineNumber - 10; i < lineNumber + 10; ++i) {
            if (this.vMap.get(i) == null) continue;
            return true;
        }
        return false;
    }

    private void outputSummary() throws IOException {
        for (Map.Entry<String, LimitedType> e : this.limitedMap.entrySet()) {
            String type = e.getKey();
            LimitedType t = e.getValue();
            this.w.println("  <type type='" + type + "' number='" + t.number + "' suppressed='" + (t.number <= this.config.getLimit() ? 0 : t.number - this.config.getLimit()) + "'/>");
        }
    }

    private void outputContents() throws IOException {
        String line;
        this.sourceReader = new BufferedReader(new FileReader(this.fileModel.getSourceFile()));
        int lineNumber = 1;
        while ((line = this.sourceReader.readLine()) != null) {
            if (!this.near(lineNumber)) {
                ++lineNumber;
                continue;
            }
            this.w.print("  <line number='" + lineNumber + "'>");
            this.w.print(XMLUtil.escapeContent(line));
            this.w.println("</line>");
            ++lineNumber;
        }
    }

    private void printAttr(String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        this.w.print("   ");
        this.w.println(XMLUtil.toAttribute(name, value.toString()));
    }

    private void doViolation(Violation v) throws IOException {
        this.w.println("  <violation");
        this.printAttr("line", v.getLine());
        this.printAttr("source", v.getSource());
        this.printAttr("severity", v.getSeverity());
        this.printAttr("type", v.getType());
        this.printAttr("message", v.getMessage().trim());
        this.printAttr("severity-level", v.getSeverityLevel());
        if (v.getPopupMessage() != null) {
            this.printAttr("popup-message", v.getPopupMessage().trim());
        }
        this.w.println("  />");
    }

    private static class LimitedType {
        private int number = 0;
        private Set<Violation> violations = new TreeSet<Violation>();

        private LimitedType() {
        }
    }
}

