/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.pmd;

import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.util.HashMapWithDefault;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class PMDParser
extends AbstractTypeParser {
    private static final HashMapWithDefault<String, String> SEVERITIES = new HashMapWithDefault("High");

    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag("pmd");
        this.getParser().next();
        while (this.skipToTag("file")) {
            this.parseFileElement();
        }
    }

    private void parseFileElement() throws IOException, XmlPullParserException {
        String absoluteFileName = this.checkNotBlank("name");
        this.getParser().next();
        FullFileModel fileModel = this.getFileModel(absoluteFileName);
        while (this.skipToTag("violation")) {
            fileModel.addViolation(this.parseViolationElement());
        }
        this.endElement();
    }

    private Violation parseViolationElement() throws IOException, XmlPullParserException {
        Violation ret = new Violation();
        ret.setType("pmd");
        String line = this.getParser().getAttributeValue("", "beginline");
        if (line == null) {
            line = this.getParser().getAttributeValue("", "line");
        }
        ret.setLine(line);
        ret.setSource(this.getParser().getAttributeValue("", "rule"));
        this.setSeverity(ret, this.getParser().getAttributeValue("", "priority"));
        ret.setMessage(this.getNextText("Expecting text"));
        this.getParser().next();
        this.endElement();
        return ret;
    }

    private void setSeverity(Violation v, String priority) {
        v.setSeverity(SEVERITIES.get(priority));
        v.setSeverityLevel(Severity.getSeverityLevel(v.getSeverity()));
    }

    static {
        SEVERITIES.put("0", "High");
        SEVERITIES.put("1", "Medium High");
        SEVERITIES.put("2", "Medium");
        SEVERITIES.put("3", "Medium Low");
        SEVERITIES.put("4", "Low");
    }
}

