/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.hudson.maven;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.hudson.maven.ViolationsModuleReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ViolationsAggregatedReport
extends ViolationsReport {
    private List<ViolationsModuleReport> reports;
    private MavenModuleSetBuild mavenBuild;
    private HealthReport healthReport = null;

    public ViolationsAggregatedReport(MavenModuleSetBuild build) {
        this.setBuild((AbstractBuild)build);
        this.mavenBuild = build;
        this.reports = new ArrayList();
        this.init();
    }

    public HealthReport getBuildHealth() {
        return this.healthReport;
    }

    public ViolationsReport getReportForMavenBuild(MavenBuild b) {
        System.out.println("getReportForMavenBuild() called b is " + b);
        for (ViolationsModuleReport moduleReport : this.reports) {
            System.out.println("Checking against " + moduleReport.getBuild());
            if (!moduleReport.getBuild().equals(b)) continue;
            return moduleReport.getReport();
        }
        return null;
    }

    private void init() {
        for (MavenBuild b : this.mavenBuild.getModuleLastBuilds().values()) {
            ViolationsBuildAction a = (ViolationsBuildAction)b.getAction(ViolationsBuildAction.class);
            if (a == null || a.getReport() == null) continue;
            ViolationsModuleReport r = new ViolationsModuleReport(b, a.getReport());
            this.reports.add(r);
            HealthReport x = a.getReport().getBuildHealth();
            HealthReport aReport = new HealthReport(x.getScore(), x.getDescription() + " in " + r.getDisplayName());
            if (aReport != null) {
                this.healthReport = HealthReport.min((HealthReport)this.healthReport, (HealthReport)aReport);
            }
            this.setConfig(a.getReport().getConfig());
            Map aggregatedViolations = this.getViolations();
            for (Map.Entry e : a.getReport().getViolations().entrySet()) {
                int val = (Integer)e.getValue();
                Integer current = (Integer)aggregatedViolations.get(e.getKey());
                if (current == null) {
                    aggregatedViolations.put(e.getKey(), e.getValue());
                    continue;
                }
                aggregatedViolations.put(e.getKey(), val + current);
            }
        }
    }
}

