/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.parse;

import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class AbstractParser {
    private XmlPullParser parser;

    protected XmlPullParser getParser() {
        return this.parser;
    }

    public void setParser(XmlPullParser parser) {
        this.parser = parser;
    }

    protected abstract void execute() throws IOException, XmlPullParserException;

    void parse(InputStream in) throws IOException, XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.parser = factory.newPullParser();
        this.parser.setInput(in, null);
        this.execute();
    }

    protected String getString(String name) throws IOException, XmlPullParserException {
        String v = this.parser.getAttributeValue("", name);
        return v == null ? "" : v;
    }

    protected int getInt(String name) throws IOException, XmlPullParserException {
        String v = this.parser.getAttributeValue("", name);
        try {
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    protected int checkGetInt(String name) throws IOException, XmlPullParserException {
        String v = this.checkGetAttribute(name);
        try {
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    protected long checkGetLong(String name) throws IOException, XmlPullParserException {
        String v = this.checkGetAttribute(name);
        try {
            return Long.parseLong(v);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    protected String checkGetAttribute(String name) throws IOException, XmlPullParserException {
        String ret = this.parser.getAttributeValue("", name);
        if (ret == null) {
            throw new XmlPullParserException("Expecting attribute " + name + " in element " + this.parser.getName());
        }
        return ret;
    }

    protected String checkNotBlank(String name) throws IOException, XmlPullParserException {
        String ret = this.parser.getAttributeValue("", name);
        if (ret == null || ret.trim().equals("")) {
            throw new XmlPullParserException("Expecting attribute " + name + " in element " + this.parser.getName());
        }
        return ret;
    }

    protected boolean skipToTag(String tagName) throws IOException, XmlPullParserException {
        while (this.parser.getEventType() != 3) {
            if (this.parser.getEventType() != 2) {
                this.parser.next();
                continue;
            }
            if (this.parser.getName().equals(tagName)) {
                return true;
            }
            this.skipTag();
        }
        return false;
    }

    protected String getSibTag() throws IOException, XmlPullParserException {
        while (this.parser.getEventType() != 3) {
            if (this.parser.getEventType() == 2) {
                return this.parser.getName();
            }
            this.parser.next();
        }
        return null;
    }

    protected void skipTag() throws IOException, XmlPullParserException {
        this.parser.next();
        this.endElement();
    }

    protected void expectStartTag(String tag) throws IOException, XmlPullParserException {
        while (true) {
            if (this.parser.getEventType() != 2) {
                this.parser.next();
                continue;
            }
            if (this.parser.getName().equals(tag)) break;
        }
    }

    protected void expectNextTag(String tag) throws IOException, XmlPullParserException {
        while (this.parser.getEventType() != 2) {
            this.parser.next();
        }
        if (this.parser.getName().equals(tag)) {
            return;
        }
        throw new IOException("Expecting tag " + tag);
    }

    protected void checkEvent(int event, String message) throws IOException, XmlPullParserException {
        if (this.parser.getEventType() != event) {
            throw new RuntimeException(message);
        }
    }

    protected void checkNextEvent(int event, String message) throws IOException, XmlPullParserException {
        this.parser.next();
        this.checkEvent(event, message);
    }

    protected String getNextText(String message) throws IOException, XmlPullParserException {
        this.checkNextEvent(4, message);
        return this.parser.getText();
    }

    protected void endElement() throws IOException, XmlPullParserException {
        while (true) {
            if (this.parser.getEventType() == 2) {
                this.parser.next();
                this.endElement();
                continue;
            }
            if (this.parser.getEventType() == 3) {
                this.parser.next();
                return;
            }
            this.parser.next();
        }
    }
}

