/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.hudson.maven;

import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsCollector;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsProjectAction;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.hudson.maven.ViolationsMavenDescriptor;
import java.io.File;
import java.io.IOException;
import org.apache.maven.project.MavenProject;

public class ViolationsMavenReporter
extends MavenReporter {
    private static final String VIOLATIONS = "violations";
    public static final ViolationsMavenDescriptor DESCRIPTOR = new ViolationsMavenDescriptor();
    private final ViolationsConfig config = new ViolationsConfig();

    public ViolationsConfig getConfig() {
        return this.config;
    }

    public ViolationsConfig getOldConfig() {
        return this.config.clone();
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){

            public Void call(MavenBuild build) throws IOException, InterruptedException {
                ViolationsMavenReporter.this.getCreateBuildAction(build);
                build.registerAsProjectAction((MavenReporter)ViolationsMavenReporter.this);
                return null;
            }
        });
        return true;
    }

    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath htmlPath = new FilePath(new File(((MavenModule)build.getProject()).getRootDir(), VIOLATIONS));
        FilePath targetPath = new FilePath(new File(build.getRootDir(), VIOLATIONS));
        ViolationsReport report = (ViolationsReport)((MavenModule)build.getProject()).getWorkspace().act((FilePath.FileCallable)new ViolationsCollector(true, targetPath, htmlPath, this.config));
        report.setConfig(this.config);
        report.setBuild((AbstractBuild<?, ?>)build);
        report.setBuildResult();
        ViolationsBuildAction buildAction = this.getCreateBuildAction(build);
        buildAction.setReport(report);
        return true;
    }

    public Action getProjectAction(MavenModule module) {
        return new ViolationsProjectAction((AbstractProject<?, ?>)module);
    }

    public MavenReporterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private ViolationsBuildAction getCreateBuildAction(MavenBuild build) {
        ViolationsBuildAction ret = (ViolationsBuildAction)build.getAction(ViolationsBuildAction.class);
        if (ret == null) {
            ret = new ViolationsBuildAction((AbstractBuild<?, ?>)build);
            build.getActions().add(ret);
        }
        return ret;
    }
}

