/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.parse;

import hudson.plugins.violations.model.FileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractParser;
import java.io.File;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class FileModelParser
extends AbstractParser {
    private FileModel fileModel;

    public FileModelParser fileModel(FileModel fileModel) {
        this.fileModel = fileModel;
        return this;
    }

    protected void execute() throws IOException, XmlPullParserException {
        String tag;
        this.expectNextTag("file");
        this.fileModel.setDisplayName(this.checkGetAttribute("name"));
        String file = this.getParser().getAttributeValue("", "file");
        if (file != null && !file.equals("")) {
            this.fileModel.setSourceFile(new File(file));
            this.fileModel.setLastModified(this.checkGetLong("last-modified"));
        }
        this.getParser().next();
        while ((tag = this.getSibTag()) != null) {
            if (tag.equals("violation")) {
                this.parseViolationElement();
                continue;
            }
            if (tag.equals("line")) {
                this.parseLineElement();
                continue;
            }
            if (tag.equals("type")) {
                this.parseTypeElement();
                continue;
            }
            this.skipTag();
        }
        this.endElement();
    }

    private void parseViolationElement() throws IOException, XmlPullParserException {
        Violation ret = new Violation();
        ret.setLine(this.checkGetInt("line"));
        ret.setSource(this.checkGetAttribute("source"));
        ret.setSeverity(this.checkGetAttribute("severity"));
        ret.setSeverityLevel(this.getInt("severity-level"));
        ret.setType(this.checkGetAttribute("type"));
        ret.setMessage(this.checkGetAttribute("message"));
        String popup = this.getParser().getAttributeValue("", "popup-message");
        if (popup != null && !popup.equals("")) {
            ret.setPopupMessage(popup);
        }
        this.fileModel.addViolation(ret);
        this.getParser().next();
        this.endElement();
    }

    private void parseLineElement() throws IOException, XmlPullParserException {
        int lineNumber = this.checkGetInt("number");
        this.getParser().next();
        String line = "";
        if (this.getParser().getEventType() == 4) {
            line = this.getParser().getText();
            this.getParser().next();
        }
        this.fileModel.getLines().put(lineNumber, line);
        this.endElement();
    }

    private void parseTypeElement() throws IOException, XmlPullParserException {
        String type = this.checkNotBlank("type");
        int number = this.checkGetInt("number");
        int suppressed = this.checkGetInt("suppressed");
        this.fileModel.addLimitType(type, number, suppressed);
        this.getParser().next();
        this.endElement();
    }
}

