/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.generate;

import hudson.FilePath;
import hudson.plugins.violations.generate.Execute;
import hudson.plugins.violations.util.CloseUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class ExecuteFilePath {
    private final FilePath targetDir;
    private final String filename;
    private final Execute ex;

    public ExecuteFilePath(FilePath targetDir, String filename, Execute ex) {
        this.targetDir = targetDir;
        this.filename = filename;
        this.ex = ex;
    }

    public void execute() throws IOException, InterruptedException {
        boolean seenException = false;
        FilePath f = this.targetDir.child(this.filename);
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(f.write(), "UTF-8")));
        try {
            this.ex.execute(w);
        }
        catch (IOException ex) {
            seenException = true;
            throw ex;
        }
        finally {
            CloseUtil.close((Closeable)w, (boolean)seenException);
        }
    }
}

