/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.generate;

import hudson.plugins.violations.generate.Execute;
import hudson.plugins.violations.generate.OutputBuildModel;
import hudson.plugins.violations.generate.XMLUtil;
import hudson.plugins.violations.model.FileSummary;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputBuildModel
implements Execute {
    private final FullBuildModel model;
    private PrintWriter writer;

    public OutputBuildModel(FullBuildModel model) {
        this.model = model;
    }

    public void execute(PrintWriter writer) throws IOException {
        this.writer = writer;
        this.header();
        for (String type : this.model.getTypeMap().keySet()) {
            this.doType(type, (SortedSet)this.model.getTypeMap().get(type));
        }
        this.footer();
    }

    private void header() throws IOException {
        this.writer.println("<violations>");
    }

    private void doType(String type, SortedSet<FileSummary> files) {
        this.writer.println("  <type name='" + type + "'>");
        for (FileSummary f : files) {
            this.writer.println("    <file");
            this.writer.println("     " + XMLUtil.toAttribute((String)"name", (String)f.getFileModel().getDisplayName()));
            this.writer.println("      count = '" + f.getViolations().size() + "'>");
            this.doSeverities(type, f.getFileModel());
            this.writer.println("  </file>");
        }
        this.writer.println("  </type>");
    }

    private void doSeverities(String type, FullFileModel file) {
        Set violations = (Set)file.getTypeMap().get(type);
        if (violations == null) {
            return;
        }
        CodeCountMap codeMap = new CodeCountMap(null);
        int[] counts = new int[5];
        for (Violation v : violations) {
            int n = v.getSeverityLevel();
            counts[n] = counts[n] + 1;
            codeMap.add(v.getSource());
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == 0) continue;
            this.writer.print("      <severity");
            this.writer.print(XMLUtil.toAttribute((String)"level", (int)i));
            this.writer.print(XMLUtil.toAttribute((String)"count", (int)counts[i]));
            this.writer.println("/>");
        }
        for (Map.Entry e : codeMap.entrySet()) {
            this.writer.print("      <source ");
            this.writer.print(XMLUtil.toAttribute((String)"name", (String)((String)e.getKey())));
            this.writer.print(XMLUtil.toAttribute((String)"count", (int)((Integer)e.getValue())));
            this.writer.println("/>");
        }
    }

    private void footer() throws IOException {
        this.writer.println("</violations>");
    }
}

