/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.model;

import hudson.plugins.violations.model.BuildModel;
import hudson.plugins.violations.render.FileModelProxy;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildModel {
    private File xmlRoot;
    private Map<String, FileModelProxy> fileModelMap = new HashMap();
    private SortedMap<String, SortedSet<FileCount>> typeMap = new TreeMap();
    private SortedMap<String, TypeCount> typeCountMap;

    public BuildModel(File xmlFile) {
        this.xmlRoot = xmlFile.getParentFile();
    }

    public SortedMap<String, SortedSet<FileCount>> getTypeMap() {
        return this.typeMap;
    }

    public Map<String, FileModelProxy> getFileModelMap() {
        return this.fileModelMap;
    }

    public Collection<TypeCount> getTypeCounts() {
        if (this.typeCountMap == null) {
            this.typeCountMap = new TreeMap();
            for (String t : this.typeMap.keySet()) {
                int count = 0;
                for (FileCount fc : (SortedSet)this.typeMap.get(t)) {
                    count += fc.getCount();
                }
                this.typeCountMap.put(t, new TypeCount(t, ((SortedSet)this.typeMap.get(t)).size(), count));
            }
        }
        return this.typeCountMap.values();
    }

    public Map<String, TypeCount> getTypeCountMap() {
        this.getTypeCounts();
        return this.typeCountMap;
    }

    public SortedSet<FileCount> getFileCounts(String type) {
        TreeSet ret = (TreeSet)this.typeMap.get(type);
        if (ret == null) {
            ret = new TreeSet();
            this.typeMap.put(type, ret);
        }
        return ret;
    }

    private FileModelProxy getFileNameProxy(String name) {
        FileModelProxy proxy = (FileModelProxy)this.fileModelMap.get(name);
        if (proxy != null) {
            return proxy;
        }
        File xmlFile = new File(this.xmlRoot, "file/" + name + ".xml");
        this.fileModelMap.put(name, new FileModelProxy(xmlFile));
        return proxy;
    }

    public void addFileCount(String type, String name, int[] count) {
        FileModelProxy proxy = this.getFileNameProxy(name);
        this.getFileCounts(type).add(new FileCount(name, count, proxy));
    }
}

