/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.fxcop;

import hudson.plugins.violations.types.fxcop.FxCopRule;
import hudson.plugins.violations.types.fxcop.XmlElementUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class FxCopRuleSet {
    private transient Map<String, FxCopRule> rules = new HashMap();

    public void addRule(Element element) {
        FxCopRule rule = new FxCopRule(element.getAttribute("TypeName"), element.getAttribute("Category"), element.getAttribute("CheckId"));
        rule.setUrl(this.getNamedTagText(element, "Url"));
        rule.setDescription(this.getNamedTagText(element, "Description"));
        rule.setName(this.getNamedTagText(element, "Name"));
        this.rules.put(this.getRuleKey(rule.getCategory(), rule.getCheckId()), rule);
    }

    private String getNamedTagText(Element element, String tagName) {
        Element foundElement = XmlElementUtil.getFirstElementByTagName((Element)element, (String)tagName);
        if (foundElement == null) {
            return "";
        }
        return foundElement.getTextContent();
    }

    public boolean contains(String category, String checkId) {
        return this.rules.containsKey(this.getRuleKey(category, checkId));
    }

    public FxCopRule getRule(String category, String checkId) {
        String key = this.getRuleKey(category, checkId);
        FxCopRule rule = null;
        if (this.rules.containsKey(key)) {
            rule = (FxCopRule)this.rules.get(key);
        }
        return rule;
    }

    private String getRuleKey(String category, String checkId) {
        return category + "#" + checkId;
    }
}

