/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.cpd;

import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.ViolationsDOMParser;
import hudson.plugins.violations.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CPDParser
extends ViolationsDOMParser {
    private static final int LOW_LIMIT = 100;
    private static final int MEDIUM_LIMIT = 1000;

    protected void execute() throws IOException, Exception {
        Element docElement = this.getDocument().getDocumentElement();
        NodeList nl = docElement.getElementsByTagName("duplication");
        if (nl == null) {
            return;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            this.parseDuplicationElement(el);
        }
    }

    private void parseDuplicationElement(Element parent) throws IOException, Exception {
        int lines = this.getInt(parent, "lines");
        int tokens = this.getInt(parent, "tokens");
        ArrayList<FileElement> fileElements = new ArrayList<FileElement>();
        NodeList nl = parent.getElementsByTagName("file");
        if (nl == null) {
            return;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            fileElements.add(this.parseFileElement(el));
        }
        FileElement prev = (FileElement)fileElements.get(fileElements.size() - 1);
        for (FileElement curr : fileElements) {
            this.addViolation(lines, tokens, curr, prev);
            prev = curr;
        }
    }

    private FileElement parseFileElement(Element parent) throws IOException, Exception {
        FileElement ret = new FileElement();
        ret.line = this.getInt(parent, "line");
        ret.path = this.fixAbsolutePath(this.checkNotBlank(parent, "path").replace('\\', '/'));
        return ret;
    }

    private String relativePoint(FileElement self, FileElement other) {
        String path = StringUtil.relativePath(self.path + "/bats", other.path);
        return path + "#line" + other.line;
    }

    private String relativeOther(FileElement self, FileElement other) {
        StringBuilder b = new StringBuilder();
        b.append("line " + other.line);
        if (!self.path.equals(other.path)) {
            b.append(" in ");
            b.append(other.path.substring(other.path.lastIndexOf("/") + 1));
        }
        return b.toString();
    }

    private String relativeHRef(FileElement self, FileElement other) {
        StringBuilder b = new StringBuilder();
        b.append("<a href='");
        b.append(this.relativePoint(self, other));
        b.append("'>");
        b.append(this.relativeOther(self, other));
        b.append("</a>");
        return b.toString();
    }

    private void addViolation(int lines, int tokens, FileElement self, FileElement other) {
        Violation v = new Violation();
        v.setType("cpd");
        v.setLine(self.line);
        this.setSeverity(v, tokens < 100 ? "Low" : (tokens < 1000 ? "Medium" : "High"));
        v.setSource("duplication");
        v.setMessage("Duplication of " + tokens + " tokens from " + this.relativeHRef(self, other));
        v.setPopupMessage("Duplication of " + tokens + " tokens from " + this.relativeOther(self, other));
        this.getFileModel(self.path).addViolation(v);
    }

    private void setSeverity(Violation v, String severity) {
        v.setSeverity(severity);
        v.setSeverityLevel(Severity.getSeverityLevel(severity));
    }

    private class FileElement {
        private int line;
        private String path;

        private FileElement() {
        }
    }
}

