/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.stylecop;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.types.fxcop.XmlElementUtil;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleCopParser
implements ViolationsParser {
    static final String TYPE_NAME = "stylecop";
    private FullBuildModel model;
    private File reportParentFile;

    @Override
    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        this.model = model;
        this.reportParentFile = new File(fileName).getParentFile();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(new File(projectPath, fileName)));
            NodeList mainNode = doc.getElementsByTagName("SourceAnalysisViolations");
            Element rootElement = (Element)mainNode.item(0);
            this.parseViolations(XmlElementUtil.getNamedChildElements(rootElement, "Violation"));
            this.findSourceFiles(model, projectPath.getPath(), sourcePaths);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
        catch (SAXException se) {
            throw new IOException(se);
        }
    }

    private void findSourceFiles(FullBuildModel model, String workspace, String[] sourcePaths) {
        AbsoluteFileFinder finder = new AbsoluteFileFinder();
        finder.addSourcePath(workspace);
        if (sourcePaths != null) {
            finder.addSourcePaths(sourcePaths);
        }
        Map<String, FullFileModel> fileModelMap = model.getFileModelMap();
        for (String key : fileModelMap.keySet()) {
            FullFileModel fileModel = fileModelMap.get(key);
            File sourceFile = finder.getFileForName(fileModel.getDisplayName());
            if (sourceFile == null) continue;
            fileModel.setSourceFile(sourceFile);
            fileModel.setLastModified(sourceFile.lastModified());
        }
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private void parseViolations(List<Element> elements) throws IOException {
        for (Element element : elements) {
            Violation violation = new Violation();
            violation.setLine(this.getString(element, "LineNumber"));
            violation.setMessage(element.getTextContent() + " (" + this.getString(element, "RuleId") + ")");
            violation.setSeverity("Medium");
            violation.setSeverityLevel(2);
            violation.setType(TYPE_NAME);
            String temp = this.getString(element, "RuleNamespace");
            int i = temp.lastIndexOf(46);
            if (i != -1) {
                violation.setSource(temp.substring(i));
            } else {
                violation.setSource(this.getString(element, "RuleId"));
            }
            String displayName = this.reportParentFile == null ? this.getString(element, "Source") : this.reportParentFile.getPath() + File.separator + this.getString(element, "Source");
            FullFileModel fileModel = this.model.getFileModel(displayName);
            fileModel.addViolation(violation);
        }
    }
}

