/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.parse;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ViolationsDOMParser
implements ViolationsParser {
    private FullBuildModel model;
    private File projectPath;
    private String[] sourcePaths;
    private Document dom;

    public Document getDocument() {
        return this.dom;
    }

    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        boolean success = false;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(new File(projectPath, fileName));
            this.setProjectPath(projectPath);
            this.setModel(model);
            this.setSourcePaths(sourcePaths);
            this.execute();
            success = true;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException2("Cannot parse " + fileName, (Throwable)ex);
        }
    }

    protected abstract void execute() throws IOException, Exception;

    public void setModel(FullBuildModel model) {
        this.model = model;
    }

    protected FullBuildModel getModel() {
        return this.model;
    }

    public void setProjectPath(File projectPath) {
        this.projectPath = projectPath;
    }

    protected File getProjectPath() {
        return this.projectPath;
    }

    public void setSourcePaths(String[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    protected String[] getSourcePaths() {
        return this.sourcePaths;
    }

    protected FullFileModel getFileModel(String name, File sourceFile) {
        FullFileModel fileModel = this.model.getFileModel(name);
        File other = fileModel.getSourceFile();
        if (sourceFile == null || other != null && (other.equals(sourceFile) || other.exists())) {
            return fileModel;
        }
        fileModel.setSourceFile(sourceFile);
        fileModel.setLastModified(sourceFile.lastModified());
        return fileModel;
    }

    protected FullFileModel getFileModel(String absoluteName) {
        File file = new File(absoluteName);
        String name = this.resolveName(absoluteName);
        return this.getFileModel(name, file);
    }

    protected String fixAbsolutePath(String abs) throws IOException {
        if (abs.contains("..")) {
            return new File(abs).getCanonicalPath();
        }
        return abs;
    }

    protected String resolveName(String absoluteName) {
        String remote = this.projectPath.getAbsolutePath().replace('\\', '/');
        String lcRemote = remote.toLowerCase(Locale.US);
        String name = absoluteName.replace('\\', '/');
        String lcName = name.toLowerCase(Locale.US);
        if (lcName.startsWith(lcRemote)) {
            name = name.substring(lcRemote.length());
        } else {
            int colPos = name.indexOf(58);
            int dirPos = name.indexOf(47);
            if (colPos != -1 && (dirPos == -1 || dirPos > colPos)) {
                name = name.substring(colPos + 1);
            }
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public int getInt(Element el, String attribute) {
        String v = el.getAttribute(attribute);
        try {
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public String checkNotBlank(Element el, String attribute) throws Exception {
        String ret = el.getAttribute(attribute);
        if (ret == null || ret.trim().equals("")) {
            throw new Exception("Expecting attribute " + attribute + " in element " + el.getLocalName());
        }
        return ret;
    }
}

