/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.pylint;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.types.pylint.PyLintParser;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PyLintParser
implements ViolationsParser {
    private final transient Pattern pattern;
    private transient AbsoluteFileFinder absoluteFileFinder = new AbsoluteFileFinder();

    public PyLintParser() {
        this.pattern = Pattern.compile("(.*):(\\d+): \\[(\\D\\d*).*\\] (.*)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        BufferedReader reader = null;
        this.absoluteFileFinder.addSourcePath(projectPath.getAbsolutePath());
        this.absoluteFileFinder.addSourcePaths(sourcePaths);
        try {
            reader = new BufferedReader(new FileReader(new File(projectPath, fileName)));
            String line = reader.readLine();
            while (line != null) {
                this.parseLine(model, line, projectPath);
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void parseLine(FullBuildModel model, String line, File projectPath) {
        PyLintViolation pyLintViolation = this.getPyLintViolation(line);
        if (pyLintViolation != null) {
            Violation violation = new Violation();
            violation.setType("pylint");
            violation.setLine(pyLintViolation.getLineStr());
            violation.setMessage(pyLintViolation.getMessage());
            violation.setSource(pyLintViolation.getViolationId());
            this.setServerityLevel(violation, pyLintViolation.getViolationId());
            FullFileModel fileModel = this.getFileModel(model, pyLintViolation.getFileName(), this.absoluteFileFinder.getFileForName(pyLintViolation.getFileName()));
            fileModel.addViolation(violation);
        }
    }

    private FullFileModel getFileModel(FullBuildModel model, String name, File sourceFile) {
        FullFileModel fileModel = model.getFileModel(name);
        File other = fileModel.getSourceFile();
        if (sourceFile == null || other != null && (other.equals(sourceFile) || other.exists())) {
            return fileModel;
        }
        fileModel.setSourceFile(sourceFile);
        fileModel.setLastModified(sourceFile.lastModified());
        return fileModel;
    }

    PyLintViolation getPyLintViolation(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 4) {
            return new PyLintViolation(this, matcher);
        }
        return null;
    }

    private void setServerityLevel(Violation violation, String messageType) {
        switch (messageType.charAt(0)) {
            case 'C': {
                violation.setSeverity("Low");
                violation.setSeverityLevel(4);
                break;
            }
            case 'R': {
                violation.setSeverity("Medium Low");
                violation.setSeverityLevel(3);
                break;
            }
            default: {
                violation.setSeverity("Medium");
                violation.setSeverityLevel(2);
                break;
            }
            case 'E': 
            case 'F': {
                violation.setSeverity("High");
                violation.setSeverityLevel(0);
            }
        }
    }
}

