/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.hudson.maven;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.hudson.maven.ViolationsModuleReport;
import hudson.plugins.violations.model.BuildModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ViolationsAggregatedReport
extends ViolationsReport {
    private List<ViolationsModuleReport> reports;
    private MavenModuleSetBuild mavenBuild;
    private HealthReport healthReport = null;

    public ViolationsAggregatedReport(MavenModuleSetBuild build) {
        this.setBuild((AbstractBuild<?, ?>)build);
        this.mavenBuild = build;
        this.reports = new ArrayList<ViolationsModuleReport>();
        this.init();
    }

    public HealthReport getBuildHealth() {
        return this.healthReport;
    }

    public BuildModel getModel() {
        return null;
    }

    public ViolationsReport getReportForMavenBuild(MavenBuild b) {
        for (ViolationsModuleReport moduleReport : this.reports) {
            if (!moduleReport.getBuild().equals(b)) continue;
            return moduleReport.getReport();
        }
        return null;
    }

    private void init() {
        for (MavenBuild b : this.mavenBuild.getModuleLastBuilds().values()) {
            ViolationsBuildAction a = (ViolationsBuildAction)b.getAction(ViolationsBuildAction.class);
            if (a == null || a.getReport() == null) continue;
            ViolationsModuleReport r = new ViolationsModuleReport(b, a.getReport());
            this.reports.add(r);
            HealthReport x = a.getReport().getBuildHealth();
            HealthReport aReport = null;
            if (x != null) {
                aReport = new HealthReport(x.getScore(), x.getDescription() + " in " + r.getDisplayName());
            }
            if (aReport != null) {
                this.healthReport = HealthReport.min((HealthReport)this.healthReport, aReport);
            }
            this.setConfig(a.getReport().getConfig());
            Map<String, Integer> aggregatedViolations = this.getViolations();
            for (Map.Entry<String, Integer> e : a.getReport().getViolations().entrySet()) {
                int val = e.getValue();
                Integer current = aggregatedViolations.get(e.getKey());
                if (current == null) {
                    aggregatedViolations.put(e.getKey(), e.getValue());
                    continue;
                }
                aggregatedViolations.put(e.getKey(), val + current);
            }
        }
    }
}

