/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.parse;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.parse.AbstractParser;
import hudson.plugins.violations.parse.XmlReader;
import hudson.plugins.violations.util.CloseUtil;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class AbstractTypeParser
extends AbstractParser
implements ViolationsParser {
    private FullBuildModel model;
    private File projectPath;
    private String[] sourcePaths;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        boolean bl;
        XmlReader in = null;
        boolean success = false;
        try {
            in = new XmlReader(new File(projectPath, fileName));
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)in);
            this.setProjectPath(projectPath);
            this.setModel(model);
            this.setParser(parser);
            this.setSourcePaths(sourcePaths);
            this.execute();
            success = true;
            bl = !success;
        }
        catch (IOException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new IOException2("Cannot parse " + fileName, (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(in, !success);
                throw throwable;
            }
        }
        CloseUtil.close(in, bl);
    }

    public void setModel(FullBuildModel model) {
        this.model = model;
    }

    protected FullBuildModel getModel() {
        return this.model;
    }

    public void setProjectPath(File projectPath) {
        this.projectPath = projectPath;
    }

    protected File getProjectPath() {
        return this.projectPath;
    }

    public void setSourcePaths(String[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    protected String[] getSourcePaths() {
        return this.sourcePaths;
    }

    protected FullFileModel getFileModel(String name, File sourceFile) {
        FullFileModel fileModel = this.model.getFileModel(name);
        File other = fileModel.getSourceFile();
        if (sourceFile == null || other != null && (other.equals(sourceFile) || other.exists())) {
            return fileModel;
        }
        fileModel.setSourceFile(sourceFile);
        fileModel.setLastModified(sourceFile.lastModified());
        return fileModel;
    }

    protected FullFileModel getFileModel(String absoluteName) {
        File file = new File(absoluteName);
        String name = this.resolveName(absoluteName);
        return this.getFileModel(name, file);
    }

    protected String fixAbsolutePath(String abs) throws IOException {
        if (abs.contains("..")) {
            return new File(abs).getCanonicalPath();
        }
        return abs;
    }

    protected String resolveName(String absoluteName) {
        String remote = this.projectPath.getAbsolutePath().replace('\\', '/');
        String lcRemote = remote.toLowerCase(Locale.US);
        String name = absoluteName.replace('\\', '/');
        String lcName = name.toLowerCase(Locale.US);
        if (lcName.startsWith(lcRemote)) {
            name = name.substring(lcRemote.length());
        } else {
            int colPos = name.indexOf(58);
            int dirPos = name.indexOf(47);
            if (colPos != -1 && (dirPos == -1 || dirPos > colPos)) {
                name = name.substring(colPos + 1);
            }
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }
}

