/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.HealthReport;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.violations.TypeSummary;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsPublisher;
import hudson.plugins.violations.hudson.AbstractViolationsBuildAction;
import hudson.plugins.violations.model.BuildModel;
import hudson.plugins.violations.model.FileModel;
import hudson.plugins.violations.model.Suppression;
import hudson.plugins.violations.parse.AbstractParser;
import hudson.plugins.violations.parse.BuildModelParser;
import hudson.plugins.violations.parse.ParseXML;
import hudson.plugins.violations.render.FileModelProxy;
import hudson.plugins.violations.render.NoViolationsFile;
import hudson.plugins.violations.util.HelpHudson;
import hudson.plugins.violations.util.RecurDynamic;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsReport
implements Serializable {
    private static final Logger LOG = Logger.getLogger(ViolationsReport.class.getName());
    private AbstractBuild<?, ?> build;
    private ViolationsConfig config;
    private Map<String, Integer> violations = new TreeMap<String, Integer>();
    private Map<String, TypeSummary> typeSummaries = new TreeMap<String, TypeSummary>();
    private transient WeakReference<BuildModel> modelReference;
    private static final long serialVersionUID = 1L;

    public void setBuild(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public void setConfig(ViolationsConfig config) {
        this.config = config;
    }

    public ViolationsConfig getConfig() {
        return this.config;
    }

    public Map<String, Integer> getViolations() {
        return this.violations;
    }

    public HealthReport getBuildHealth() {
        List<HealthReport> reports = this.getBuildHealths();
        HealthReport ret = null;
        for (HealthReport report : reports) {
            ret = HealthReport.min(ret, (HealthReport)report);
        }
        return ret;
    }

    public List<HealthReport> getBuildHealths() {
        ArrayList<HealthReport> ret = new ArrayList<HealthReport>();
        for (String type : this.config.getTypeConfigs().keySet()) {
            HealthReport health = this.getHealthReportFor(type);
            if (health == null) continue;
            ret.add(health);
        }
        return ret;
    }

    public HealthReport getHealthReportFor(String type) {
        Integer count = this.violations.get(type);
        if (count == null || this.config.getTypeConfigs() == null) {
            return null;
        }
        int h = this.config.getTypeConfigs().get(type).getHealthFor(count);
        if (h < 0) {
            return new HealthReport(0, "No xml report files found for " + type);
        }
        return new HealthReport(h, "Number of " + type + " violations is " + count);
    }

    public BuildModel getModel() {
        BuildModel model = null;
        if (this.modelReference != null && (model = (BuildModel)this.modelReference.get()) != null) {
            return model;
        }
        File xmlFile = new File(this.build.getRootDir(), "violations/violations.xml");
        try {
            model = new BuildModel(xmlFile);
            ParseXML.parse(xmlFile, (AbstractParser)new BuildModelParser().buildModel(model));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Unable to parse " + xmlFile, ex);
            return null;
        }
        this.modelReference = new WeakReference<BuildModel>(model);
        return model;
    }

    public FileModelProxy getFileModelProxy(String name) {
        BuildModel model = this.getModel();
        if (model == null) {
            return null;
        }
        return model.getFileModelMap().get(name);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        FileModelProxy proxy;
        String name = req.getRestOfPath();
        if (name.equals("")) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((proxy = this.getFileModelProxy(name)) != null) {
            return new RecurDynamic("", name, proxy.build(this.build).contextPath(req.getContextPath()));
        }
        return new RecurDynamic("", name, new NoViolationsFile(name, this.build));
    }

    public ViolationsConfig getLiveConfig() {
        AbstractProject abstractProject;
        AbstractProject notQuestion = abstractProject = this.build.getProject();
        if (abstractProject instanceof Project) {
            Project project = (Project)abstractProject;
            ViolationsPublisher publisher = (ViolationsPublisher)project.getPublisher(ViolationsPublisher.DESCRIPTOR);
            return publisher == null ? null : publisher.getConfig();
        }
        return null;
    }

    public void addSuppression(Suppression suppression) throws IOException {
        ViolationsConfig config = this.getLiveConfig();
        if (config != null) {
            config.getSuppressions().add(suppression);
            ((AbstractProject)this.build.getParent()).save();
        }
    }

    public void removeSuppression(Suppression suppression) throws IOException {
        ViolationsConfig config = this.getLiveConfig();
        if (config != null) {
            config.getSuppressions().remove(suppression);
            ((AbstractProject)this.build.getParent()).save();
        }
    }

    public Map<String, TypeSummary> getTypeSummaries() {
        return this.typeSummaries;
    }

    public TypeSummary getTypeSummary(String type) {
        TypeSummary ret = this.typeSummaries.get(type);
        if (ret == null) {
            ret = new TypeSummary();
            this.typeSummaries.put(type, ret);
        }
        return ret;
    }

    public Map<String, TypeReport> getTypeReports() {
        TreeMap<String, TypeReport> ret = new TreeMap<String, TypeReport>();
        for (String t : this.violations.keySet()) {
            int c = this.violations.get(t);
            HealthReport health = this.getHealthReportFor(t);
            ret.put(t, new TypeReport(t, health.getIconUrl(), c));
        }
        return ret;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        AbstractViolationsBuildAction r;
        AbstractBuild<?, ?> tBuild = this.build;
        int buildNumber = HelpHudson.findBuildNumber(req);
        if (buildNumber != 0 && (tBuild = (AbstractBuild<?, ?>)((AbstractProject)this.build.getParent()).getBuildByNumber(buildNumber)) == null) {
            tBuild = this.build;
        }
        if ((r = (AbstractViolationsBuildAction)tBuild.getAction(AbstractViolationsBuildAction.class)) == null) {
            return;
        }
        r.doGraph(req, rsp);
    }

    public String getNumberString(String t) {
        Integer v = this.violations.get(t);
        if (v == null) {
            return "";
        }
        if (v < 0) {
            return "<span style='color:red'>No reports</span>";
        }
        return "" + v;
    }

    public String getIcon(String t) {
        Integer v = this.violations.get(t);
        HealthReport h = this.getHealthReportFor(t);
        if (h == null) {
            return null;
        }
        return h.getIconUrl();
    }

    public ViolationsReport previous() {
        return ViolationsReport.findViolationsReport((AbstractBuild)this.build.getPreviousBuild());
    }

    public int typeCount(String type) {
        if (this.getModel() == null) {
            return 0;
        }
        return this.getModel().getTypeCountMap().get(type).getCount();
    }

    public int fileCount(String type) {
        if (this.getModel() == null) {
            return 0;
        }
        return this.getModel().getTypeCountMap().get(type).getNumberFiles();
    }

    public int violationCount(String type, String filename) {
        FileModelProxy proxy = this.getFileModelProxy(filename);
        if (proxy == null) {
            return 0;
        }
        FileModel fileModel = proxy.getFileModel();
        if (fileModel == null) {
            return 0;
        }
        FileModel.LimitType limit = (FileModel.LimitType)fileModel.getLimitTypeMap().get(type);
        if (limit == null) {
            return 0;
        }
        return limit.getNumber();
    }

    private boolean isUnstable() {
        for (String t : this.violations.keySet()) {
            int count = this.violations.get(t);
            Integer unstableLimit = this.config.getTypeConfigs().get(t).getUnstable();
            if (unstableLimit == null || count < unstableLimit) continue;
            return true;
        }
        return false;
    }

    private boolean isFailed() {
        for (String t : this.violations.keySet()) {
            int count = this.violations.get(t);
            Integer failCount = this.config.getTypeConfigs().get(t).getFail();
            if (failCount == null || count < failCount) continue;
            return true;
        }
        return false;
    }

    public void setBuildResult() {
        if (this.isFailed()) {
            this.build.setResult(Result.FAILURE);
            return;
        }
        if (this.isUnstable()) {
            this.build.setResult(Result.UNSTABLE);
        }
    }

    public static ViolationsReport findViolationsReport(AbstractBuild<?, ?> b) {
        while (b != null) {
            AbstractViolationsBuildAction action;
            if (!b.getResult().isWorseOrEqualTo(Result.FAILURE) && (action = (AbstractViolationsBuildAction)b.getAction(AbstractViolationsBuildAction.class)) != null && action.getReport() != null) {
                ViolationsReport ret = action.getReport();
                ret.setBuild(b);
                return ret;
            }
            b = (AbstractBuild)b.getPreviousBuild();
        }
        return null;
    }

    public static ViolationsReportIterator iteration(AbstractBuild<?, ?> build) {
        return new ViolationsReportIterator(build);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViolationsReportIterator
    implements Iterator<ViolationsReport>,
    Iterable<ViolationsReport> {
        private AbstractBuild<?, ?> curr;

        public ViolationsReportIterator(AbstractBuild<?, ?> curr) {
            this.curr = curr;
        }

        @Override
        public Iterator<ViolationsReport> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return ViolationsReport.findViolationsReport(this.curr) != null;
        }

        @Override
        public ViolationsReport next() {
            ViolationsReport ret = ViolationsReport.findViolationsReport(this.curr);
            if (ret != null) {
                this.curr = (AbstractBuild)ret.getBuild().getPreviousBuild();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class TypeReport {
        private final String type;
        private final String icon;
        private final int number;

        public TypeReport(String type, String icon, int number) {
            this.type = type;
            this.icon = icon;
            this.number = number;
        }

        public String getType() {
            return this.type;
        }

        public String getIcon() {
            return this.icon;
        }

        public int getNumber() {
            return this.number;
        }

        public String getNumberString() {
            if (this.number >= 0) {
                return "" + this.number;
            }
            return "<span style='color:red'>No reports</span>";
        }
    }
}

