/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.parse;

import hudson.plugins.violations.parse.AbstractParser;
import hudson.plugins.violations.parse.XmlReader;
import hudson.plugins.violations.util.CloseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public final class ParseXML {
    private static final Logger LOG = Logger.getLogger(ParseXML.class.getName());

    private ParseXML() {
        LOG.log(Level.FINE, "private constructor called");
    }

    public static void parse(InputStream in, AbstractParser xmlParser) throws IOException {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)new XmlReader(in));
            xmlParser.setParser(parser);
            xmlParser.execute();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static void parse(File xmlFile, AbstractParser xmlParser) throws IOException {
        FileInputStream in = null;
        boolean seenException = false;
        try {
            in = new FileInputStream(xmlFile);
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)new XmlReader(in));
            xmlParser.setParser(parser);
            xmlParser.execute();
        }
        catch (IOException ex) {
            seenException = true;
            throw ex;
        }
        catch (Exception ex) {
            seenException = true;
            throw new IOException(ex);
        }
        finally {
            CloseUtil.close(in, seenException);
        }
    }
}

