/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.generate;

import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.generate.Execute;
import hudson.plugins.violations.generate.OutputFileModel;
import hudson.plugins.violations.generate.XMLUtil;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.util.CloseUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class OutputFileModel
implements Execute {
    private static final int NEAR = 10;
    private final FullFileModel fileModel;
    private final ViolationsConfig config;
    private PrintWriter w;
    private BufferedReader sourceReader = null;
    private HashMap<Integer, Set<Violation>> vMap = new HashMap();
    private SortedMap<String, LimitedType> limitedMap = new TreeMap();

    public OutputFileModel(FullFileModel fileModel, ViolationsConfig config) {
        this.fileModel = fileModel;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PrintWriter w) throws IOException {
        this.w = w;
        w.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        w.println("<file");
        w.print(" ");
        w.println(XMLUtil.toAttribute((String)"name", (String)this.fileModel.getDisplayName()));
        w.print(" ");
        w.println(XMLUtil.toAttribute((String)"last-modified", (String)("" + this.fileModel.getLastModified())));
        if (this.fileModel.getSourceFile() != null) {
            w.print(" ");
            w.println(XMLUtil.toAttribute((String)"file", (String)this.fileModel.getSourceFile().getAbsolutePath()));
        }
        w.println(">");
        this.createLimited();
        if (this.fileModel.getSourceFile() != null && this.fileModel.getSourceFile().exists()) {
            try {
                this.outputContents();
            }
            finally {
                this.closeSourceFile();
            }
        }
        this.outputSummary();
        w.println("</file>");
    }

    private void addToVMap(Violation v) {
        if (this.vMap.get(v.getLine()) == null) {
            this.vMap.put(v.getLine(), new TreeSet());
        }
        ((Set)this.vMap.get(v.getLine())).add(v);
    }

    private void createLimited() throws IOException {
        for (Map.Entry e : this.fileModel.getTypeMap().entrySet()) {
            String type = (String)e.getKey();
            Set violations = (Set)e.getValue();
            LimitedType limitedType = new LimitedType(null);
            LimitedType.access$102((LimitedType)limitedType, (int)violations.size());
            int c = 0;
            for (Violation v : violations) {
                LimitedType.access$200((LimitedType)limitedType).add(v);
                this.addToVMap(v);
                this.doViolation(v);
                if (++c < this.config.getLimit()) continue;
                break;
            }
            this.limitedMap.put(type, limitedType);
        }
    }

    private void closeSourceFile() {
        CloseUtil.close((Closeable)this.sourceReader);
        this.sourceReader = null;
    }

    private boolean near(int lineNumber) {
        for (int i = lineNumber - 10; i < lineNumber + 10; ++i) {
            if (this.vMap.get(i) == null) continue;
            return true;
        }
        return false;
    }

    private void outputSummary() throws IOException {
        for (Map.Entry e : this.limitedMap.entrySet()) {
            String type = (String)e.getKey();
            LimitedType t = (LimitedType)e.getValue();
            this.w.println("  <type type='" + type + "' number='" + LimitedType.access$100((LimitedType)t) + "' suppressed='" + (LimitedType.access$100((LimitedType)t) <= this.config.getLimit() ? 0 : LimitedType.access$100((LimitedType)t) - this.config.getLimit()) + "'/>");
        }
    }

    private Reader open() throws IOException {
        if ("default".equals(this.config.getEncoding())) {
            return new FileReader(this.fileModel.getSourceFile());
        }
        FileInputStream is = new FileInputStream(this.fileModel.getSourceFile());
        try {
            return new InputStreamReader((InputStream)is, this.config.getEncoding());
        }
        catch (IOException ex) {
            CloseUtil.close((Closeable)is);
            throw ex;
        }
    }

    private void outputContents() throws IOException {
        String line;
        this.sourceReader = new BufferedReader(this.open());
        int lineNumber = 1;
        while ((line = this.sourceReader.readLine()) != null) {
            if (!this.near(lineNumber)) {
                ++lineNumber;
                continue;
            }
            this.w.print("  <line number='" + lineNumber + "'>");
            this.w.print(XMLUtil.escapeContent((String)line));
            this.w.println("</line>");
            ++lineNumber;
        }
    }

    private void printAttr(String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        this.w.print("   ");
        this.w.println(XMLUtil.toAttribute((String)name, (String)value.toString()));
    }

    private void doViolation(Violation v) throws IOException {
        this.w.println("  <violation");
        this.printAttr("line", (Object)v.getLine());
        this.printAttr("source", (Object)v.getSource());
        this.printAttr("severity", (Object)v.getSeverity());
        this.printAttr("type", (Object)v.getType());
        this.printAttr("message", (Object)v.getMessage().trim());
        this.printAttr("severity-level", (Object)v.getSeverityLevel());
        if (v.getPopupMessage() != null) {
            this.printAttr("popup-message", (Object)v.getPopupMessage().trim());
        }
        this.w.println("  />");
    }
}

