/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.model;

import hudson.plugins.violations.model.FileSummary;
import hudson.plugins.violations.model.FullFileModel;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullBuildModel {
    private SortedMap<String, SortedSet<FileSummary>> typeMap = new TreeMap();
    private Map<String, FullFileModel> fileModels = new HashMap();

    public SortedMap<String, SortedSet<FileSummary>> getTypeMap() {
        return this.typeMap;
    }

    public Map<String, FullFileModel> getFileModelMap() {
        return this.fileModels;
    }

    public int getCountNumber(String type) {
        SortedSet files = (SortedSet)this.typeMap.get(type);
        if (files == null) {
            return 0;
        }
        int count = 0;
        for (FileSummary file : files) {
            count += file.getViolations().size();
        }
        return count;
    }

    public void addType(String type) {
        this.getTypeSummary(type);
    }

    public SortedSet<FileSummary> getTypeSummary(String type) {
        TreeSet ret = (TreeSet)this.typeMap.get(type);
        if (ret == null) {
            ret = new TreeSet();
            this.typeMap.put(type, ret);
        }
        return ret;
    }

    public FullFileModel getFileModel(String displayName) {
        FullFileModel ret = (FullFileModel)this.fileModels.get(displayName);
        if (ret == null) {
            ret = new FullFileModel();
            ret.setDisplayName(displayName);
            this.fileModels.put(displayName, ret);
        }
        return ret;
    }

    public void cleanup() {
        for (FullFileModel file : this.fileModels.values()) {
            for (String type : file.getTypeMap().keySet()) {
                SortedSet set = this.getTypeSummary(type);
                set.add(new FileSummary(file, (TreeSet)file.getTypeMap().get(type)));
            }
        }
    }
}

