/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.gendarme;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.ParseUtil;
import hudson.plugins.violations.types.fxcop.XmlElementUtil;
import hudson.plugins.violations.types.gendarme.DotNetAssembly;
import hudson.plugins.violations.types.gendarme.GendarmeRule;
import hudson.plugins.violations.types.gendarme.GendarmeRuleType;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GendarmeParser
implements ViolationsParser {
    static final Logger logger = Logger.getLogger(GendarmeParser.class.toString());
    static final String TYPE_NAME = "gendarme";
    private FullBuildModel model;
    private File reportParentFile;
    private File projectPath;
    private String[] sourcePaths;
    private HashMap<String, GendarmeRule> rules;

    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        logger.info("Starting Gendarme parsing");
        this.projectPath = projectPath;
        this.model = model;
        this.reportParentFile = new File(fileName).getParentFile();
        this.sourcePaths = sourcePaths;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(new File(projectPath, fileName)));
            NodeList mainNode = doc.getElementsByTagName("gendarme-output");
            Element rootElement = (Element)mainNode.item(0);
            Element resultsElement = (Element)rootElement.getElementsByTagName("results").item(0);
            Element rulesElement = (Element)rootElement.getElementsByTagName("rules").item(0);
            this.parseRules(XmlElementUtil.getNamedChildElements((Element)rulesElement, (String)"rule"));
            this.parseViolations(XmlElementUtil.getNamedChildElements((Element)resultsElement, (String)"rule"));
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
        catch (SAXException se) {
            throw new IOException(se);
        }
    }

    private void parseViolations(List<Element> ruleElements) {
        AbsoluteFileFinder finder = new AbsoluteFileFinder();
        finder.addSourcePath(this.projectPath.getPath());
        if (this.sourcePaths != null) {
            finder.addSourcePaths(this.sourcePaths);
        }
        for (Element ruleElement : ruleElements) {
            String ruleName = ruleElement.getAttribute("Name");
            GendarmeRule rule = (GendarmeRule)this.rules.get(ruleName);
            String problem = ruleElement.getElementsByTagName("problem").item(0).getTextContent();
            String solution = ruleElement.getElementsByTagName("solution").item(0).getTextContent();
            List targetElements = XmlElementUtil.getNamedChildElements((Element)ruleElement, (String)"target");
            for (Element targetElement : targetElements) {
                FullFileModel fileModel;
                String targetAssembly = targetElement.getAttribute("Assembly");
                DotNetAssembly assembly = new DotNetAssembly(targetAssembly);
                Element defectElement = (Element)targetElement.getElementsByTagName("defect").item(0);
                String severityString = defectElement.getAttribute("Severity");
                String source = defectElement.getAttribute("Source");
                String confidence = defectElement.getAttribute("Confidence");
                String filePath = "";
                String fileName = "";
                int line = 0;
                if (rule.getType() == GendarmeRuleType.Method) {
                    Pattern pattern = Pattern.compile("^(.*)\\(.([0-9]*)\\)$");
                    Matcher matcher = pattern.matcher(source);
                    logger.info("matcher.groupCount() : " + matcher.groupCount());
                    logger.info("matcher.matches() : " + matcher.matches());
                    logger.info("source : " + source);
                    if (matcher.matches()) {
                        for (int cpt = 0; cpt < matcher.groupCount(); ++cpt) {
                            logger.info("group(" + (cpt + 1) + "): " + matcher.group(cpt + 1));
                        }
                    }
                    if (matcher.matches()) {
                        String fullPath = matcher.group(1);
                        File sourceFile = new File(fullPath);
                        fileName = sourceFile.getName();
                        filePath = sourceFile.getParent();
                        line = Integer.parseInt(matcher.group(2));
                    }
                }
                Violation violation = new Violation();
                StringBuilder messageBuilder = new StringBuilder();
                if (rule.getUrl() != null) {
                    messageBuilder.append("<a href=\"").append(rule.getUrl().toString()).append("\">");
                    messageBuilder.append(rule.getName());
                    messageBuilder.append("</a>");
                } else {
                    messageBuilder.append(rule.getName());
                }
                messageBuilder.append(" - ").append(problem).append("<br/>");
                messageBuilder.append("Solution: ").append(solution).append("<br/>");
                messageBuilder.append("Confidence: ").append(confidence);
                violation.setMessage(messageBuilder.toString());
                violation.setPopupMessage(problem);
                if (severityString.equals("Low")) {
                    violation.setSeverityLevel(4);
                    violation.setSeverity("Low");
                } else if (severityString.equals("Medium")) {
                    violation.setSeverityLevel(2);
                    violation.setSeverity("Medium");
                } else if (severityString.equals("High")) {
                    violation.setSeverityLevel(0);
                    violation.setSeverity("High");
                } else {
                    violation.setSeverityLevel(2);
                    violation.setSeverity("Medium");
                }
                violation.setType(TYPE_NAME);
                violation.setSource(rule.getName());
                if (filePath.length() > 0 && fileName.length() > 0) {
                    violation.setLine(line);
                    String displayName = ParseUtil.resolveAbsoluteName((File)this.projectPath, (String)(filePath + File.separatorChar + fileName));
                    fileModel = this.model.getFileModel(displayName);
                    if (fileModel.getSourceFile() == null) {
                        finder.addSourcePath(filePath);
                        File sourceFile = finder.getFileForName(fileName);
                        if (sourceFile != null && sourceFile.exists()) {
                            fileModel.setSourceFile(sourceFile);
                            fileModel.setLastModified(sourceFile.lastModified());
                            logger.info("fileModel.getSourceFile() : " + fileModel.getSourceFile().getAbsolutePath());
                        } else {
                            logger.info("sourceFile.exists()==false: " + filePath + "," + fileName);
                        }
                    } else {
                        logger.info("fileModel.getSourceFile() != null: " + displayName);
                    }
                } else {
                    fileModel = this.model.getFileModel(assembly.getName() + ".dll");
                    logger.info("fileModel.getSourceFile() : " + (fileModel.getSourceFile() == null ? "null" : fileModel.getSourceFile().getAbsolutePath()));
                }
                logger.info("fileModel.getDisplayName() : " + fileModel.getDisplayName());
                logger.info("reportParentFile : " + this.reportParentFile);
                logger.info("fileName : " + fileName);
                logger.info("filePath : " + filePath);
                fileModel.addViolation(violation);
            }
        }
    }

    private void parseRules(List<Element> ruleElements) {
        this.rules = new HashMap();
        for (Element ruleElement : ruleElements) {
            GendarmeRule rule = new GendarmeRule();
            rule.setName(ruleElement.getAttribute("Name"));
            rule.setTypeName(ruleElement.getTextContent());
            String typeString = ruleElement.getAttribute("Type");
            if (typeString.equals("Type")) {
                rule.setType(GendarmeRuleType.Type);
            } else if (typeString.equals("Method")) {
                rule.setType(GendarmeRuleType.Method);
            } else if (typeString.equals("Assembly")) {
                rule.setType(GendarmeRuleType.Assembly);
            }
            try {
                rule.setUrl(new URL(ruleElement.getAttribute("Uri")));
            }
            catch (MalformedURLException e) {
                rule.setUrl(null);
            }
            this.rules.put(rule.getName(), rule);
        }
    }
}

