/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.codenarc;

import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.util.HashMapWithDefault;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class CodenarcParser
extends AbstractTypeParser {
    private static final HashMapWithDefault<String, String> SEVERITIES = new HashMapWithDefault("Medium");

    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag("CodeNarc");
        this.getParser().next();
        while (this.skipToTag("Package")) {
            String path = this.checkNotBlank("path");
            this.getParser().next();
            while (this.skipToTag("File")) {
                this.parseFileElement(path);
            }
            this.endElement();
        }
        this.endElement();
    }

    private void parseFileElement(String path) throws IOException, XmlPullParserException {
        String absoluteFileName = this.fixAbsolutePath(this.getProjectPath().getAbsolutePath() + "/" + path + "/" + this.checkNotBlank("name"));
        this.getParser().next();
        FullFileModel fileModel = this.getFileModel(absoluteFileName);
        while (this.skipToTag("Violation")) {
            fileModel.addViolation(this.parseViolationElement());
            this.endElement();
        }
        this.endElement();
    }

    private Violation parseViolationElement() throws IOException, XmlPullParserException {
        Violation ret = new Violation();
        ret.setType("codenarc");
        ret.setLine(this.getString("lineNumber"));
        ret.setSource(this.getString("ruleName"));
        this.setSeverity(ret, this.getString("priority"));
        this.getParser().next();
        try {
            this.expectNextTag("SourceLine");
        }
        catch (IOException ioe) {
            this.expectNextTag("Message");
        }
        ret.setSource(this.getNextText("Missing SourceLine or Message"));
        this.getParser().next();
        this.endElement();
        return ret;
    }

    private void setSeverity(Violation v, String severity) {
        v.setSeverity(SEVERITIES.get(severity));
        v.setSeverityLevel(Severity.getSeverityLevel(v.getSeverity()));
    }

    static {
        SEVERITIES.put("1", "High");
        SEVERITIES.put("2", "Medium");
        SEVERITIES.put("3", "Low");
    }
}

