/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.findbugs;

import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.types.findbugs.FindBugsDescriptor;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import hudson.plugins.violations.util.HashMapWithDefault;
import hudson.plugins.violations.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class FindBugsParser
extends AbstractTypeParser {
    private static final Logger LOG = Logger.getLogger(FindBugsParser.class.getName());
    private boolean debug = false;
    private AbsoluteFileFinder absoluteFileFinder = new AbsoluteFileFinder();
    private String classname;
    private String path;
    private String lineNumber;
    private static final HashMapWithDefault<String, String> SEVERITIES = new HashMapWithDefault("High");

    protected void execute() throws IOException, XmlPullParserException {
        String tag;
        this.expectNextTag("BugCollection");
        this.getParser().next();
        this.absoluteFileFinder.addSourcePaths(this.getSourcePaths());
        while ((tag = this.getSibTag()) != null) {
            if (tag.equals("Project")) {
                this.getSourceDirs();
                continue;
            }
            if (tag.equals("BugInstance")) {
                this.getBugInstance();
                continue;
            }
            if (tag.equals("file")) {
                this.getMavenFileInstance();
                continue;
            }
            this.skipTag();
        }
    }

    private String resolveClassName(String classname) {
        if (classname == null) {
            return null;
        }
        String filename = classname.replace('.', '/');
        int pos = filename.indexOf(36);
        if (pos != -1) {
            filename = filename.substring(0, pos);
        }
        return filename + ".java";
    }

    private String getRelativeName(String name, File file) {
        String absolute;
        String relative;
        if (file != null && file.exists() && !(relative = this.resolveName(absolute = file.getAbsolutePath())).equals(absolute)) {
            return relative;
        }
        return name;
    }

    private void getMavenFileInstance() throws IOException, XmlPullParserException {
        String tag;
        String classname = this.checkNotBlank("classname");
        String name = this.resolveClassName(classname);
        File file = this.absoluteFileFinder.getFileForName(name);
        name = this.getRelativeName(name, file);
        this.getParser().next();
        while ((tag = this.getSibTag()) != null) {
            if (tag.equals("BugInstance")) {
                Violation v = new Violation();
                v.setType("findbugs");
                v.setLine(this.getInt("lineNumber"));
                v.setSource(this.checkNotBlank("type"));
                v.setSeverity(this.normalizeSeverity(this.checkNotBlank("priority")));
                v.setSeverityLevel(this.getSeverityLevel(v.getSeverity()));
                v.setMessage(this.checkNotBlank("message"));
                this.getFileModel(name, file).addViolation(v);
            }
            this.skipTag();
        }
        this.endElement();
    }

    private void getSourceDirs() throws IOException, XmlPullParserException {
        this.expectStartTag("Project");
        this.getParser().next();
        while (this.skipToTag("SrcDir")) {
            this.getSourceDir();
        }
        this.endElement();
    }

    private void getSourceDir() throws IOException, XmlPullParserException {
        this.checkNextEvent(4, "Expecting text");
        this.absoluteFileFinder.addSourcePath(this.getParser().getText());
        this.endElement();
    }

    private void getBugInstances() throws IOException, XmlPullParserException {
        while (this.skipToTag("BugInstance")) {
            this.getBugInstance();
        }
    }

    private String convertType(String x) {
        String y = FindBugsDescriptor.getMessageMap().get(x);
        return y == null ? x : y;
    }

    private void getSourceLine() throws IOException, XmlPullParserException {
        String l;
        if (StringUtil.isBlank(this.path)) {
            this.path = this.getParser().getAttributeValue("", "sourcepath");
        }
        if (StringUtil.isBlank(this.classname)) {
            this.classname = this.getParser().getAttributeValue("", "classname");
        }
        if (!StringUtil.isBlank(l = this.getParser().getAttributeValue("", "start"))) {
            this.lineNumber = l;
        }
    }

    private void getSourceLines() throws IOException, XmlPullParserException {
        String tag;
        while ((tag = this.getSibTag()) != null) {
            if ("SourceLine".equals(tag)) {
                this.getSourceLine();
            }
            this.skipTag();
        }
        return;
    }

    private boolean sameClassname(String currentClassname) {
        if (currentClassname == null) {
            return true;
        }
        String thisClassname = this.getParser().getAttributeValue("", "classname");
        if (StringUtil.isBlank(thisClassname)) {
            return true;
        }
        return thisClassname.equals(currentClassname);
    }

    private void getBugInstance() throws IOException, XmlPullParserException {
        String name;
        String tag;
        String type = this.getParser().getAttributeValue("", "type");
        String priority = this.getParser().getAttributeValue("", "priority");
        String category = this.getParser().getAttributeValue("", "category");
        this.getParser().next();
        this.classname = null;
        this.path = null;
        this.lineNumber = null;
        while ((tag = this.getSibTag()) != null) {
            if (("Class".equals(tag) || "Method".equals(tag) || "Field".equals(tag)) && this.sameClassname(this.classname)) {
                if (StringUtil.isBlank(this.classname)) {
                    this.classname = this.getParser().getAttributeValue("", "classname");
                }
                this.getParser().next();
                this.getSourceLines();
                this.endElement();
                continue;
            }
            if ("SourceLine".equals(tag)) {
                this.getSourceLine();
            }
            this.skipTag();
        }
        String string = name = this.path == null ? this.resolveClassName(this.classname) : this.path;
        if (StringUtil.isBlank(name)) {
            LOG.info("Unable to decode BugInstance element");
            this.endElement();
            return;
        }
        File file = this.absoluteFileFinder.getFileForName(name);
        name = this.getRelativeName(name, file);
        Violation v = new Violation();
        v.setType("findbugs");
        v.setLine(this.lineNumber);
        v.setSource(type);
        v.setSeverity(this.normalizeSeverity(priority));
        v.setSeverityLevel(this.getSeverityLevel(v.getSeverity()));
        v.setMessage(this.convertType(type));
        this.getFileModel(name, file).addViolation(v);
        this.endElement();
    }

    private String normalizeSeverity(String name) {
        return SEVERITIES.get(name);
    }

    private int getSeverityLevel(String severity) {
        return Severity.getSeverityLevel(severity);
    }

    static {
        SEVERITIES.put("1", "High");
        SEVERITIES.put("2", "Medium");
        SEVERITIES.put("3", "Low");
        SEVERITIES.put("High", "High");
        SEVERITIES.put("Medium", "Medium");
        SEVERITIES.put("Normal", "Medium");
        SEVERITIES.put("Low", "Low");
    }
}

