/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.remoting.Launcher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class Client {
    private String macAddress;
    private final DatagramSocket socket = new DatagramSocket();

    public Client() throws IOException {
        this.socket.setBroadcast(true);
        this.macAddress = this.getMacAddress();
    }

    public void start() throws Exception {
        DatagramPacket packet = this.discover();
        ByteArrayInputStream is = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        String url = dom.getElementsByTagName("url").item(0).getTextContent();
        System.out.println("Hudson: " + url);
        Launcher.main((String[])new String[]{"-jnlpUrl", this.getJnlp(url)});
    }

    public String getJnlp(String hudsonUrl) {
        return hudsonUrl + "plugin/virtualbox/getSlaveAgent?macAddress=" + this.macAddress;
    }

    private String getMacAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (byte aMac : mac) {
                    sb.append(String.format("%02X", aMac));
                }
                String macAddress = sb.toString();
                System.out.println("MAC Address for interface '" + ni.getDisplayName() + "': " + macAddress);
                return macAddress;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    protected void sendBroadcast() throws IOException {
        DatagramPacket packet = new DatagramPacket(new byte[0], 0);
        packet.setAddress(InetAddress.getByName("255.255.255.255"));
        packet.setPort(Integer.getInteger("hudson.udp", 33848));
        this.socket.send(packet);
    }

    protected DatagramPacket discover() throws IOException {
        this.sendBroadcast();
        long limit = System.currentTimeMillis() + 5000L;
        try {
            this.socket.setSoTimeout(Math.max(1, (int)(limit - System.currentTimeMillis())));
            DatagramPacket packet = new DatagramPacket(new byte[2048], 2048);
            this.socket.receive(packet);
            return packet;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        new Client().start();
    }
}

