/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxLauncher;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerLauncherFilter;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class VirtualBoxLauncher
extends ComputerLauncherFilter {
    private static final Logger LOG = Logger.getLogger(VirtualBoxLauncher.class.getName());
    private String hostName;
    private String virtualMachineName;

    @DataBoundConstructor
    public VirtualBoxLauncher(ComputerLauncher delegate, String hostName, String virtualMachineName) {
        super(delegate);
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        LOG.info("Launch: " + computer.getName());
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine((String)this.getHostName(), (String)this.getVirtualMachineName());
        if (machine == null) {
            LOG.warning("Can't find specified VirtualBox host or machine");
            VirtualBoxLauncher.log((TaskListener)listener, (String)"Can't find specified VirtualBox host or machine");
            return;
        }
        VirtualBoxLauncher.log((TaskListener)listener, (String)Messages.VirtualBoxLauncher_startVM((Object)machine));
        try {
            long result = VirtualBoxUtils.startVm((VirtualBoxMachine)machine);
            VirtualBoxLauncher.log((TaskListener)listener, (String)("Result: " + result));
            if (result != 0L) {
                VirtualBoxLauncher.log((TaskListener)listener, (String)Messages.VirtualBoxLauncher_startFailed((Object)machine));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception", e);
            e.printStackTrace(listener.getLogger());
        }
        if (this.getCore() != null) {
            super.launch(computer, listener);
        }
    }

    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        LOG.info("Before disconnect: " + computer.getName());
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine((String)this.getHostName(), (String)this.getVirtualMachineName());
        if (machine == null) {
            LOG.warning("Can't find specified VirtualBox host or machine");
            VirtualBoxLauncher.log((TaskListener)listener, (String)"Can't find specified VirtualBox host or machine");
            return;
        }
        if (this.getCore() != null) {
            super.beforeDisconnect(computer, listener);
        }
        VirtualBoxLauncher.log((TaskListener)listener, (String)Messages.VirtualBoxLauncher_stopVM((Object)machine));
        try {
            VirtualBoxUtils.stopVm((VirtualBoxMachine)machine);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception", e);
            e.printStackTrace(listener.getLogger());
        }
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        LOG.info("After disconnect: " + computer.getName());
        if (this.getCore() != null) {
            super.afterDisconnect(computer, listener);
        }
    }

    private static void log(TaskListener listener, String message) {
        listener.getLogger().println("[VirtualBox] " + message);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorOrDie(VirtualBoxLauncher.class);
    }
}

