/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxHost;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualBoxBuildWrapper
extends BuildWrapper {
    private String hostName;
    private String virtualMachineName;

    @DataBoundConstructor
    public VirtualBoxBuildWrapper(String hostName, String virtualMachineName) {
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(this.getHostName(), this.getVirtualMachineName());
        listener.getLogger().println(Messages.VirtualBoxLauncher_startVM(machine));
        VirtualBoxUtils.startVm(machine);
        class EnvironmentImpl
        extends BuildWrapper.Environment {
            EnvironmentImpl() {
                super((BuildWrapper)VirtualBoxBuildWrapper.this);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(VirtualBoxBuildWrapper.this.getHostName(), VirtualBoxBuildWrapper.this.getVirtualMachineName());
                listener.getLogger().println(Messages.VirtualBoxLauncher_stopVM(machine));
                VirtualBoxUtils.stopVm(machine);
                return true;
            }
        }
        return new EnvironmentImpl();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        public String getDisplayName() {
            return Messages.VirtualBoxBuildWrapper_displayName();
        }

        public List<VirtualBoxMachine> getDefinedVirtualMachines(String hostName) {
            return VirtualBoxPlugin.getDefinedVirtualMachines(hostName);
        }

        public List<VirtualBoxHost> getHosts() {
            return VirtualBoxPlugin.getHosts();
        }
    }
}

