/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxHost;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerLauncherFilter;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualBoxLauncher
extends ComputerLauncherFilter {
    private static final Logger LOG = Logger.getLogger(VirtualBoxLauncher.class.getName());
    private String hostName;
    private String virtualMachineName;

    @DataBoundConstructor
    public VirtualBoxLauncher(ComputerLauncher delegate, String hostName, String virtualMachineName) {
        super(delegate);
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        LOG.info("Launch: " + computer.getName());
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(this.getHostName(), this.getVirtualMachineName());
        if (machine == null) {
            LOG.warning("Can't find specified VirtualBox host or machine");
            VirtualBoxLauncher.log(listener, "Can't find specified VirtualBox host or machine");
            return;
        }
        VirtualBoxLauncher.log(listener, Messages.VirtualBoxLauncher_startVM(machine));
        try {
            long result = VirtualBoxUtils.startVm(machine);
            VirtualBoxLauncher.log(listener, "Result: " + result);
            if (result != 0L) {
                VirtualBoxLauncher.log(listener, Messages.VirtualBoxLauncher_startFailed(machine));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception", e);
            e.printStackTrace(listener.getLogger());
        }
        if (this.getCore() != null) {
            super.launch(computer, listener);
        }
    }

    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        LOG.info("Before disconnect: " + computer.getName());
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(this.getHostName(), this.getVirtualMachineName());
        if (machine == null) {
            LOG.warning("Can't find specified VirtualBox host or machine");
            VirtualBoxLauncher.log(listener, "Can't find specified VirtualBox host or machine");
            return;
        }
        if (this.getCore() != null) {
            super.beforeDisconnect(computer, listener);
        }
        VirtualBoxLauncher.log(listener, Messages.VirtualBoxLauncher_stopVM(machine));
        try {
            VirtualBoxUtils.stopVm(machine);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception", e);
            e.printStackTrace(listener.getLogger());
        }
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        LOG.info("After disconnect: " + computer.getName());
        if (this.getCore() != null) {
            super.afterDisconnect(computer, listener);
        }
    }

    private static void log(TaskListener listener, String message) {
        listener.getLogger().println("[VirtualBox] " + message);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorOrDie(VirtualBoxLauncher.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return Messages.VirtualBoxLauncher_displayName();
        }

        public List<VirtualBoxMachine> getDefinedVirtualMachines(String hostName) {
            return VirtualBoxPlugin.getDefinedVirtualMachines(hostName);
        }

        public List<VirtualBoxHost> getHosts() {
            return VirtualBoxPlugin.getHosts();
        }
    }
}

