/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Plugin;
import hudson.model.Hudson;
import hudson.plugins.virtualbox.VirtualBoxHost;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxPlugin
extends Plugin {
    private static final Logger LOG = Logger.getLogger(VirtualBoxPlugin.class.getName());

    public void start() throws Exception {
        LOG.info("Starting " + ((Object)((Object)this)).getClass().getSimpleName());
        super.start();
    }

    public void stop() throws Exception {
        LOG.info("Stopping " + ((Object)((Object)this)).getClass().getSimpleName());
        super.stop();
    }

    public static List<VirtualBoxHost> getHosts() {
        ArrayList<VirtualBoxHost> result = new ArrayList<VirtualBoxHost>();
        for (Cloud cloud : Hudson.getInstance().clouds) {
            if (!(cloud instanceof VirtualBoxHost)) continue;
            result.add((VirtualBoxHost)cloud);
        }
        return result;
    }

    public static VirtualBoxHost getHost(String hostName) {
        if (hostName == null) {
            return null;
        }
        for (VirtualBoxHost host : VirtualBoxPlugin.getHosts()) {
            if (!hostName.equals(host.getDisplayName())) continue;
            return host;
        }
        return null;
    }

    public static List<VirtualBoxMachine> getDefinedVirtualMachines(String hostName) {
        VirtualBoxHost host = VirtualBoxPlugin.getHost(hostName);
        if (host == null) {
            return Collections.emptyList();
        }
        return host.getVirtualMachines();
    }

    public static VirtualBoxMachine getVirtualBoxMachine(String hostName, String virtualMachineName) {
        if (virtualMachineName == null) {
            return null;
        }
        VirtualBoxHost host = VirtualBoxPlugin.getHost(hostName);
        if (host == null) {
            return null;
        }
        for (VirtualBoxMachine machine : host.getVirtualMachines()) {
            if (!virtualMachineName.equals(machine.getName())) continue;
            return machine;
        }
        return null;
    }

    public void doComputerNameValues(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="hostName") String hostName) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        List<VirtualBoxMachine> virtualMachines = VirtualBoxPlugin.getDefinedVirtualMachines(hostName);
        if (virtualMachines != null && virtualMachines.size() > 0) {
            for (VirtualBoxMachine vm : virtualMachines) {
                m.add((Object)new ListBoxModel.Option(vm.getName(), vm.getName()));
            }
            ((ListBoxModel.Option)m.get((int)0)).selected = true;
        }
        m.writeTo(req, resp);
    }
}

