/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import com.sun.xml.ws.commons.virtualbox.IMachine;
import com.sun.xml.ws.commons.virtualbox.IProgress;
import com.sun.xml.ws.commons.virtualbox.ISession;
import com.sun.xml.ws.commons.virtualbox.IVirtualBox;
import com.sun.xml.ws.commons.virtualbox.InvalidObjectFaultMsg;
import com.sun.xml.ws.commons.virtualbox.RuntimeFaultMsg;
import com.sun.xml.ws.commons.virtualbox.VboxPortType;
import com.sun.xml.ws.commons.virtualbox.VboxService;
import com.sun.xml.ws.commons.virtualbox.VirtualBox;
import hudson.plugins.virtualbox.VirtualBoxHost;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualBoxUtils {
    private VirtualBoxUtils() {
    }

    private static IVirtualBox connect(VirtualBoxHost host) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(IVirtualBox.class.getClassLoader());
        try {
            URL wsdl = VirtualBox.class.getClassLoader().getResource("vboxwebService.wsdl");
            if (wsdl == null) {
                throw new LinkageError("vboxwebService.wsdl not found, but it should have been in the jar");
            }
            VboxService svc = new VboxService(wsdl, new QName("http://www.virtualbox.org/Service", "vboxService"));
            VboxPortType port = svc.getVboxServicePort();
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", host.getUrl());
            String vbox = port.iWebsessionManagerLogon(host.getUsername(), host.getPassword());
            IVirtualBox iVirtualBox = new IVirtualBox(vbox, port);
            return iVirtualBox;
        }
        catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (RuntimeFaultMsg e) {
            throw new WebServiceException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static List<VirtualBoxMachine> getMachines(VirtualBoxHost host) {
        ArrayList<VirtualBoxMachine> result = new ArrayList<VirtualBoxMachine>();
        IVirtualBox box = VirtualBoxUtils.connect(host);
        for (IMachine machine : box.getMachines()) {
            result.add(new VirtualBoxMachine(host, machine.getName()));
        }
        box.logoff();
        return result;
    }

    public static long startVm(VirtualBoxMachine vbMachine) {
        IVirtualBox box = VirtualBoxUtils.connect(vbMachine.getHost());
        ISession session = box.getSessionObject();
        IMachine machine = box.findMachine(vbMachine.getName());
        IProgress progress = box.openRemoteSession(session, machine.getId(), "headless", "");
        progress.waitForCompletion(-1);
        box.logoff();
        return progress.getResultCode();
    }

    public static void stopVm(VirtualBoxMachine vbMachine) {
        IVirtualBox box = VirtualBoxUtils.connect(vbMachine.getHost());
        IMachine machine = box.findMachine(vbMachine.getName());
        ISession session = box.getSessionObject();
        box.openExistingSession(box.getSessionObject(), machine.getId());
        session.getConsole().powerDown();
        box.logoff();
    }
}

