/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.virtualbox.VirtualBoxComputer;
import hudson.plugins.virtualbox.VirtualBoxComputerLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxSlave
extends Slave {
    private static final Logger LOG = Logger.getLogger(VirtualBoxSlave.class.getName());
    private final String hostName;
    private final String virtualMachineName;
    private final String virtualMachineType;

    @DataBoundConstructor
    public VirtualBoxSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String hostName, String virtualMachineName, String virtualMachineType) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new VirtualBoxComputerLauncher(delegateLauncher), retentionStrategy, nodeProperties);
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
        this.virtualMachineType = virtualMachineType;
    }

    public Computer createComputer() {
        return new VirtualBoxComputer((Slave)this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getVirtualMachineType() {
        return this.virtualMachineType;
    }

    public VirtualBoxComputerLauncher getLauncher() {
        return (VirtualBoxComputerLauncher)super.getLauncher();
    }

    public ComputerLauncher getDelegateLauncher() {
        return this.getLauncher().getCore();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

