/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualBoxBuildWrapper
extends BuildWrapper {
    private String hostName;
    private String virtualMachineName;

    @DataBoundConstructor
    public VirtualBoxBuildWrapper(String hostName, String virtualMachineName) {
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(this.getHostName(), this.getVirtualMachineName());
        listener.getLogger().println(Messages.VirtualBoxLauncher_startVM(machine));
        VirtualBoxUtils.startVm(machine, "headless");
        class EnvironmentImpl
        extends BuildWrapper.Environment {
            EnvironmentImpl() {
                super((BuildWrapper)VirtualBoxBuildWrapper.this);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(VirtualBoxBuildWrapper.this.getHostName(), VirtualBoxBuildWrapper.this.getVirtualMachineName());
                listener.getLogger().println(Messages.VirtualBoxLauncher_stopVM(machine));
                VirtualBoxUtils.stopVm(machine);
                return true;
            }
        }
        return new EnvironmentImpl();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }
}

