/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxComputer;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.plugins.virtualbox.VirtualBoxSlave;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxComputerLauncher
extends ComputerLauncher {
    private static final Logger LOG = Logger.getLogger(VirtualBoxComputerLauncher.class.getName());
    private static final int SECOND = 1000;
    private ComputerLauncher delegate;

    public VirtualBoxComputerLauncher(ComputerLauncher delegate) {
        this.delegate = delegate;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        VirtualBoxSlave slave = ((VirtualBoxComputer)computer).getNode();
        try {
            VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(slave.getHostName(), slave.getVirtualMachineName());
            if (machine == null) {
                listener.fatalError("Unable to find specified machine");
                return;
            }
            VirtualBoxComputerLauncher.log(listener, Messages.VirtualBoxLauncher_startVM(machine));
            long result = VirtualBoxUtils.startVm(machine, slave.getVirtualMachineType());
            if (result != 0L) {
                listener.fatalError("Unable to launch");
                return;
            }
        }
        catch (Throwable e) {
            listener.fatalError(e.getMessage(), new Object[]{e});
            e.printStackTrace(listener.getLogger());
            LOG.log(Level.WARNING, e.getMessage(), e);
            return;
        }
        boolean successful = false;
        int attempt = 0;
        while (!successful) {
            VirtualBoxComputerLauncher.log(listener, "Sleep before stage 2 launcher, attempt " + ++attempt);
            Thread.sleep(10000L);
            successful = this.delegateLaunch(computer, listener);
            if (successful || attempt <= 10) continue;
            VirtualBoxComputerLauncher.log(listener, "Maximum number of attempts reached");
            return;
        }
    }

    protected boolean delegateLaunch(SlaveComputer computer, TaskListener listener) {
        try {
            VirtualBoxComputerLauncher.log(listener, "Starting stage 2 launcher (" + this.delegate.getClass().getSimpleName() + ")");
            this.getCore().launch(computer, listener);
            VirtualBoxComputerLauncher.log(listener, "Stage 2 launcher completed");
            return true;
        }
        catch (IOException e) {
            VirtualBoxComputerLauncher.log(listener, "Unable to launch: " + e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            VirtualBoxComputerLauncher.log(listener, "Unable to launch: " + e.getMessage());
            return false;
        }
    }

    private static void log(TaskListener listener, String message) {
        listener.getLogger().println("[VirtualBox] " + message);
    }

    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        VirtualBoxComputerLauncher.log(listener, "Starting stage 2 beforeDisconnect");
        this.getCore().beforeDisconnect(computer, listener);
        VirtualBoxComputerLauncher.log(listener, "Stage 2 beforeDisconnect completed");
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        VirtualBoxSlave slave = ((VirtualBoxComputer)computer).getNode();
        VirtualBoxComputerLauncher.log(listener, "Starting stage 2 afterDisconnect");
        this.getCore().afterDisconnect(computer, listener);
        VirtualBoxComputerLauncher.log(listener, "Stage 2 afterDisconnect completed");
        try {
            VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine(slave.getHostName(), slave.getVirtualMachineName());
            if (machine == null) {
                listener.fatalError("Unable to find specified machine");
            }
            VirtualBoxComputerLauncher.log(listener, Messages.VirtualBoxLauncher_stopVM(machine));
            long result = VirtualBoxUtils.stopVm(machine);
            if (result != 0L) {
                listener.fatalError("Unable to stop");
                return;
            }
        }
        catch (Throwable e) {
            listener.fatalError(e.getMessage(), new Object[]{e});
        }
    }

    public ComputerLauncher getCore() {
        return this.delegate;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

