/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxCloud;
import hudson.plugins.virtualbox.VirtualBoxComputer;
import hudson.plugins.virtualbox.VirtualBoxComputerLauncher;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxSlave
extends Slave {
    private static final Logger LOG = Logger.getLogger(VirtualBoxSlave.class.getName());
    private final String hostName;
    private final String virtualMachineName;
    private final String virtualMachineType;

    @DataBoundConstructor
    public VirtualBoxSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String hostName, String virtualMachineName, String virtualMachineType) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new VirtualBoxComputerLauncher(delegateLauncher), retentionStrategy, nodeProperties);
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
        this.virtualMachineType = virtualMachineType;
    }

    public Computer createComputer() {
        return new VirtualBoxComputer(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getVirtualMachineType() {
        return this.virtualMachineType;
    }

    public VirtualBoxComputerLauncher getLauncher() {
        return (VirtualBoxComputerLauncher)super.getLauncher();
    }

    public ComputerLauncher getDelegateLauncher() {
        return this.getLauncher().getCore();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return Messages.VirtualBoxSlave_displayName();
        }

        public List<VirtualBoxMachine> getDefinedVirtualMachines(String hostName) {
            return VirtualBoxPlugin.getDefinedVirtualMachines(hostName);
        }

        public List<VirtualBoxCloud> getHosts() {
            return VirtualBoxPlugin.getHosts();
        }

        public FormValidation doCheckHostName(@QueryParameter String value) {
            LOG.info("Perform on the fly check - hostName");
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"VirtualBox Host is mandatory");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVirtualMachineName(@QueryParameter String value) {
            LOG.info("Perform on the fly check - virtualMachineName");
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Virtual Machine Name is mandatory");
            }
            return FormValidation.ok();
        }
    }
}

