/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import com.sun.xml.ws.commons.virtualbox_3_1.IMachine;
import com.sun.xml.ws.commons.virtualbox_3_1.IProgress;
import com.sun.xml.ws.commons.virtualbox_3_1.ISession;
import com.sun.xml.ws.commons.virtualbox_3_1.IVirtualBox;
import com.sun.xml.ws.commons.virtualbox_3_1.IWebsessionManager;
import hudson.plugins.virtualbox.VirtualBoxCloud;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import java.util.ArrayList;
import java.util.List;
import org.virtualbox_3_1.MachineState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualBoxUtils {
    private VirtualBoxUtils() {
    }

    private static ConnectionHolder connect(VirtualBoxCloud host) {
        IWebsessionManager manager = new IWebsessionManager(host.getUrl());
        ConnectionHolder holder = new ConnectionHolder();
        holder.manager = manager;
        holder.vbox = manager.logon(host.getUsername(), host.getPassword());
        return holder;
    }

    public static List<VirtualBoxMachine> getMachines(VirtualBoxCloud host) {
        ArrayList<VirtualBoxMachine> result = new ArrayList<VirtualBoxMachine>();
        ConnectionHolder holder = VirtualBoxUtils.connect(host);
        for (IMachine machine : holder.vbox.getMachines()) {
            result.add(new VirtualBoxMachine(host, machine.getName()));
        }
        holder.disconnect();
        return result;
    }

    public static long startVm(VirtualBoxMachine vbMachine, String type) {
        ConnectionHolder holder = VirtualBoxUtils.connect(vbMachine.getHost());
        ISession session = holder.manager.getSessionObject(holder.vbox);
        IMachine machine = holder.vbox.findMachine(vbMachine.getName());
        if (MachineState.RUNNING == machine.getState()) {
            return 0L;
        }
        IProgress progress = holder.vbox.openRemoteSession(session, machine.getId(), type, "");
        progress.waitForCompletion(Integer.valueOf(-1));
        long result = progress.getResultCode().intValue();
        holder.disconnect();
        return result;
    }

    public static long stopVm(VirtualBoxMachine vbMachine) {
        ConnectionHolder holder = VirtualBoxUtils.connect(vbMachine.getHost());
        ISession session = holder.manager.getSessionObject(holder.vbox);
        IMachine machine = holder.vbox.findMachine(vbMachine.getName());
        if (MachineState.RUNNING != machine.getState()) {
            return 0L;
        }
        holder.vbox.openExistingSession(session, machine.getId());
        IProgress progress = session.getConsole().powerDown();
        progress.waitForCompletion(Integer.valueOf(-1));
        long result = progress.getResultCode().intValue();
        holder.disconnect();
        return result;
    }

    public static String getMacAddress(VirtualBoxMachine vbMachine) {
        ConnectionHolder holder = VirtualBoxUtils.connect(vbMachine.getHost());
        IMachine machine = holder.vbox.findMachine(vbMachine.getName());
        String macAddress = machine.getNetworkAdapter(Long.valueOf(0L)).getMACAddress();
        holder.disconnect();
        return macAddress;
    }

    static class ConnectionHolder {
        IWebsessionManager manager;
        IVirtualBox vbox;

        ConnectionHolder() {
        }

        public void disconnect() {
            this.manager.disconnect(this.vbox);
        }
    }
}

