/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxBuildWrapper;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxPlugin;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualBoxBuildWrapper
extends BuildWrapper {
    private String hostName;
    private String virtualMachineName;

    @DataBoundConstructor
    public VirtualBoxBuildWrapper(String hostName, String virtualMachineName) {
        this.hostName = hostName;
        this.virtualMachineName = virtualMachineName;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        VirtualBoxMachine machine = VirtualBoxPlugin.getVirtualBoxMachine((String)this.getHostName(), (String)this.getVirtualMachineName());
        listener.getLogger().println(Messages.VirtualBoxLauncher_startVM((Object)machine));
        VirtualBoxUtils.startVm((VirtualBoxMachine)machine, (String)"headless");
        return new EnvironmentImpl(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }
}

