/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.plugins.virtualbox.VirtualBoxCloud;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxSlave;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class VirtualBoxPlugin
extends Plugin {
    private static final Logger LOG = Logger.getLogger(VirtualBoxPlugin.class.getName());

    public void start() throws Exception {
        LOG.info("Starting " + this.getClass().getSimpleName());
        super.start();
    }

    public void stop() throws Exception {
        LOG.info("Stopping " + this.getClass().getSimpleName());
        super.stop();
    }

    public static List<VirtualBoxCloud> getHosts() {
        ArrayList<VirtualBoxCloud> result = new ArrayList<VirtualBoxCloud>();
        for (Cloud cloud : Hudson.getInstance().clouds) {
            if (!(cloud instanceof VirtualBoxCloud)) continue;
            result.add((VirtualBoxCloud)cloud);
        }
        return result;
    }

    public static VirtualBoxCloud getHost(String hostName) {
        if (hostName == null) {
            return null;
        }
        for (VirtualBoxCloud host : VirtualBoxPlugin.getHosts()) {
            if (!hostName.equals(host.getDisplayName())) continue;
            return host;
        }
        return null;
    }

    public static List<VirtualBoxMachine> getDefinedVirtualMachines(String hostName) {
        VirtualBoxCloud host = VirtualBoxPlugin.getHost((String)hostName);
        if (host == null) {
            return Collections.emptyList();
        }
        return host.getVirtualMachines();
    }

    public static VirtualBoxMachine getVirtualBoxMachine(String hostName, String virtualMachineName) {
        if (virtualMachineName == null) {
            return null;
        }
        VirtualBoxCloud host = VirtualBoxPlugin.getHost((String)hostName);
        if (host == null) {
            return null;
        }
        for (VirtualBoxMachine machine : host.getVirtualMachines()) {
            if (!virtualMachineName.equals(machine.getName())) continue;
            return machine;
        }
        return null;
    }

    public void doComputerNameValues(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="hostName") String hostName) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        List virtualMachines = VirtualBoxPlugin.getDefinedVirtualMachines((String)hostName);
        if (virtualMachines != null && virtualMachines.size() > 0) {
            for (VirtualBoxMachine vm : virtualMachines) {
                m.add((Object)new ListBoxModel.Option(vm.getName(), vm.getName()));
            }
            ((ListBoxModel.Option)m.get((int)0)).selected = true;
        }
        m.writeTo(req, resp);
    }

    public void doGetSlaveAgent(StaplerRequest req, StaplerResponse resp, @QueryParameter(value="macAddress") String macAddress) throws IOException {
        LOG.info("Searching VirtualBox machine with MacAddress " + macAddress);
        for (Node node : Hudson.getInstance().getNodes()) {
            if (!(node instanceof VirtualBoxSlave)) continue;
            VirtualBoxSlave slave = (VirtualBoxSlave)node;
            VirtualBoxMachine vbox = VirtualBoxPlugin.getVirtualBoxMachine((String)slave.getHostName(), (String)slave.getVirtualMachineName());
            String vboxMacAddress = VirtualBoxUtils.getMacAddress((VirtualBoxMachine)vbox);
            LOG.info("MacAddress for " + slave.getNodeName() + " is " + vboxMacAddress);
            if (!macAddress.equalsIgnoreCase(vboxMacAddress)) continue;
            String url = Hudson.getInstance().getRootUrl() + "/computer/" + slave.getNodeName() + "/slave-agent.jnlp";
            LOG.info("Found " + slave + " for Mac Address " + macAddress + ", sending redirect to " + url);
            resp.sendRedirect(url);
            return;
        }
        resp.sendError(404);
    }
}

