/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.virtualbox;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.plugins.virtualbox.Messages;
import hudson.plugins.virtualbox.VirtualBoxMachine;
import hudson.plugins.virtualbox.VirtualBoxUtils;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxCloud
extends Cloud {
    private static final Logger LOG = Logger.getLogger(VirtualBoxCloud.class.getName());
    private final String url;
    private final String username;
    private final String password;
    private transient List<VirtualBoxMachine> virtualBoxMachines = null;

    @DataBoundConstructor
    public VirtualBoxCloud(String displayName, String url, String username, String password) {
        super(displayName);
        this.url = url;
        this.username = username;
        this.password = Scrambler.scramble((String)Util.fixEmptyAndTrim((String)password));
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        return Collections.emptyList();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    private List<VirtualBoxMachine> retrieveMachines() {
        return VirtualBoxUtils.getMachines(this);
    }

    public List<VirtualBoxMachine> getVirtualMachines() {
        if (this.virtualBoxMachines == null) {
            this.virtualBoxMachines = this.retrieveMachines();
        }
        return this.virtualBoxMachines;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return Scrambler.descramble((String)this.password);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("VirtualBoxHost");
        sb.append("{url='").append(this.url).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return Messages.VirtualBoxHost_displayName();
        }

        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String username, @QueryParameter String password) {
            LOG.info("Testing connection to " + url + " with username " + username);
            try {
                VirtualBoxUtils.getMachines(new VirtualBoxCloud("testConnection", url, username, password));
                return FormValidation.ok((String)Messages.VirtualBoxHost_success());
            }
            catch (Throwable e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

