/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.model.Result;
import hudson.plugins.vmware.Host;
import hudson.plugins.vmware.VMware;
import hudson.plugins.vmware.VMwareActivationWrapper;
import hudson.plugins.vmware.VMwareRuntimeException;
import hudson.plugins.vmware.VirtualMachine;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMwareActivationWrapper
extends BuildWrapper
implements ResourceActivity {
    public transient String vixLibraryPath;
    public transient String hostName;
    public transient String username;
    public transient String password;
    public transient int portNumber;
    public transient boolean suspend;
    public transient boolean waitForTools;
    public transient boolean revert;
    public transient String configFile;
    private List<VMActivationConfig> machines;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(VMwareActivationWrapper.class.getName());

    private void importOldConfig() {
        assert (this.machines == null);
        this.machines = new ArrayList();
        VMwareHostConfig hostConfig = null;
        if (this.vixLibraryPath != null) {
            hostConfig = new VMwareHostConfig(this.vixLibraryPath, this.hostName, this.portNumber, Host.HostType.VMWARE_SERVER, this.username, this.password);
            boolean found = false;
            for (VMwareHostConfig h : DESCRIPTOR.getHosts()) {
                if (!h.equals((Object)hostConfig)) continue;
                found = true;
                hostConfig = h;
                break;
            }
            if (!found) {
                hostConfig.setName(hostConfig.getUsername() + "@" + hostConfig.getHostType() + ":" + hostConfig.getPortNumber());
                DESCRIPTOR.addHost(hostConfig);
            }
        }
        if (hostConfig == null) {
            hostConfig = (VMwareHostConfig)DESCRIPTOR.getHosts().get(0);
        }
        if (this.configFile != null && !"".equals(this.configFile)) {
            VMActivationConfig cfg = new VMActivationConfig();
            cfg.setVmxFilePath(this.configFile);
            cfg.setHostConfig(hostConfig);
            if (this.waitForTools) {
                cfg.setPowerUpMode(this.revert ? VMWrapperPowerUpMode.REVERT_WAIT : VMWrapperPowerUpMode.NORMAL_WAIT);
            } else {
                cfg.setPowerUpMode(this.revert ? VMWrapperPowerUpMode.REVERT : VMWrapperPowerUpMode.NORMAL);
            }
            cfg.setPowerDownMode(this.suspend ? VMWrapperPowerDownMode.SUSPEND : VMWrapperPowerDownMode.NORMAL);
            this.machines.add(cfg);
        }
    }

    public List<VMActivationConfig> getMachines() {
        if (this.machines == null) {
            this.importOldConfig();
        }
        return this.machines;
    }

    public void setMachines(List<VMActivationConfig> machines) {
        this.machines = machines;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        ArrayList<VMC> vms = new ArrayList<VMC>();
        try {
            VMware library = null;
            String lastLibrary = null;
            for (VMActivationConfig machine : this.machines) {
                VMwareHostConfig config = machine.getHostConfig();
                if (lastLibrary == null || !lastLibrary.equals(config.getVixLibraryPath())) {
                    lastLibrary = config.getVixLibraryPath();
                    library = new VMware(lastLibrary);
                }
                buildListener.getLogger().println("[VMware] Connecting to VMware Server host " + config.getHostName() + ":" + config.getPortNumber() + " as user " + config.getUsername());
                Host host = library.connect(config.getHostType(), config.getHostName(), config.getPortNumber(), config.getUsername(), config.getPassword());
                try {
                    buildListener.getLogger().println("[VMware] Opening virtual machine: " + machine.getVmxFilePath());
                    VirtualMachine vm = host.open(machine.getVmxFilePath());
                    try {
                        VMC vmc = new VMC(this, vm, host, machine);
                        vmc.powerUp(buildListener);
                        vms.add(vmc);
                    }
                    catch (VMwareRuntimeException e) {
                        vm.close();
                        throw e;
                    }
                }
                catch (VMwareRuntimeException e) {
                    host.disconnect();
                    throw e;
                    return new EnvironmentImpl(this, vms);
                }
            }
        }
        catch (VMwareRuntimeException e) {
            buildListener.getLogger().println("[VMware] VMware VIX error: " + e.getMessage());
            e.printStackTrace(buildListener.getLogger());
            build.setResult(Result.FAILURE);
            for (VMC vmc : vms) {
                vmc.powerDown(buildListener);
            }
            return null;
        }
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public ResourceList getResourceList() {
        ResourceList resources = new ResourceList();
        for (VMActivationConfig machine : this.machines) {
            resources.w(new Resource(machine.getHost() + "/" + machine.getVmxFilePath()));
        }
        return resources;
    }

    public String getDisplayName() {
        return DESCRIPTOR.getDisplayName();
    }
}

