/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import hudson.plugins.vmware.Host;
import hudson.plugins.vmware.VMwareRuntimeException;
import hudson.plugins.vmware.vix.Vix;
import java.util.logging.Logger;

public class VMware {
    private static final Logger LOGGER = Logger.getLogger(VMware.class.getName());
    private final Vix instance;

    public VMware() {
        this.instance = (Vix)Native.loadLibrary((String)"vix", Vix.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMware(String pathToLib) {
        String oldProp = System.getProperty("jna.library.path");
        try {
            System.setProperty("jna.library.path", pathToLib);
            this.instance = (Vix)Native.loadLibrary((String)"vix", Vix.class);
        }
        finally {
            if (oldProp != null) {
                System.setProperty("jna.library.path", oldProp);
            }
        }
    }

    public Host connect(Host.HostType hostType, String hostName, int hostPort, String userName, String password) {
        return new Host(this, hostType, hostName, hostPort, userName, password);
    }

    Vix getInstance() {
        return this.instance;
    }

    int waitForJobAndGetJobResultHandle(int jobHandle) {
        IntByReference result = new IntByReference();
        this.checkError(this.instance.VixJob_Wait(jobHandle, 3010, result, 0));
        return result.getValue();
    }

    void waitForJob(int jobHandle) {
        this.checkError(this.instance.VixJob_Wait(jobHandle, 0));
    }

    void checkError(int err) {
        if (err != 0) {
            String errorMessage = this.instance.Vix_GetErrorText(err, null);
            LOGGER.warning(errorMessage);
            throw new VMwareRuntimeException(errorMessage);
        }
    }
}

