/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.model.Result;
import hudson.plugins.vmware.Host;
import hudson.plugins.vmware.VMware;
import hudson.plugins.vmware.VMwareRuntimeException;
import hudson.plugins.vmware.VirtualMachine;
import hudson.tasks.BuildWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMwareActivationWrapper
extends BuildWrapper
implements ResourceActivity {
    public transient String vixLibraryPath;
    public transient String hostName;
    public transient String username;
    public transient String password;
    public transient int portNumber;
    public transient boolean suspend;
    public transient boolean waitForTools;
    public transient boolean revert;
    public transient String configFile;
    private List<VMActivationConfig> machines;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(VMwareActivationWrapper.class.getName());

    private void importOldConfig() {
        assert (this.machines == null);
        this.machines = new ArrayList<VMActivationConfig>();
        VMwareHostConfig hostConfig = null;
        if (this.vixLibraryPath != null) {
            hostConfig = new VMwareHostConfig(this.vixLibraryPath, this.hostName, this.portNumber, Host.HostType.VMWARE_SERVER, this.username, this.password);
            boolean found = false;
            for (VMwareHostConfig h : DESCRIPTOR.getHosts()) {
                if (!h.equals(hostConfig)) continue;
                found = true;
                hostConfig = h;
                break;
            }
            if (!found) {
                hostConfig.setName(hostConfig.getUsername() + "@" + (Object)((Object)hostConfig.getHostType()) + ":" + hostConfig.getPortNumber());
                DESCRIPTOR.addHost(hostConfig);
            }
        }
        if (hostConfig == null) {
            hostConfig = DESCRIPTOR.getHosts().get(0);
        }
        if (this.configFile != null && !"".equals(this.configFile)) {
            VMActivationConfig cfg = new VMActivationConfig();
            cfg.setVmxFilePath(this.configFile);
            cfg.setHostConfig(hostConfig);
            if (this.waitForTools) {
                cfg.setPowerUpMode(this.revert ? VMWrapperPowerUpMode.REVERT_WAIT : VMWrapperPowerUpMode.NORMAL_WAIT);
            } else {
                cfg.setPowerUpMode(this.revert ? VMWrapperPowerUpMode.REVERT : VMWrapperPowerUpMode.NORMAL);
            }
            cfg.setPowerDownMode(this.suspend ? VMWrapperPowerDownMode.SUSPEND : VMWrapperPowerDownMode.NORMAL);
            this.machines.add(cfg);
        }
    }

    public List<VMActivationConfig> getMachines() {
        if (this.machines == null) {
            this.importOldConfig();
        }
        return this.machines;
    }

    public void setMachines(List<VMActivationConfig> machines) {
        this.machines = machines;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        final class VMC {
            private final VirtualMachine vm;
            private final Host host;
            private long powerTime;
            private final VMActivationConfig cfg;

            public VMC(VirtualMachine vm, Host host, VMActivationConfig cfg) {
                this.vm = vm;
                this.host = host;
                this.powerTime = this.powerTime;
                this.cfg = cfg;
            }

            public void powerUp(BuildListener buildListener) {
                buildListener.getLogger().println("[VMware] Pre-build for " + this.cfg.getVmxFilePath() + " on " + this.cfg.getHost() + "...");
                switch (this.cfg.getPowerUpMode()) {
                    case NOTHING: {
                        break;
                    }
                    case REVERT: 
                    case REVERT_WAIT: {
                        buildListener.getLogger().println("[VMware] Reverting virtual machine to current snapshot.");
                        this.vm.revertToSnapshot();
                    }
                    case NORMAL: 
                    case NORMAL_WAIT: {
                        buildListener.getLogger().println("[VMware] Powering up virtual machine.");
                        this.vm.powerOn();
                        break;
                    }
                }
                switch (this.cfg.getPowerUpMode()) {
                    case REVERT_WAIT: 
                    case NORMAL_WAIT: {
                        buildListener.getLogger().println("[VMware] Waiting for VMware Tools to start in virtual machine.");
                        this.vm.waitForToolsInGuest(this.cfg.waitTimeout);
                        break;
                    }
                }
                this.powerTime = System.currentTimeMillis();
                buildListener.getLogger().println("[VMware] Pre-build for " + this.cfg.getVmxFilePath() + " on " + this.cfg.getHost() + " completed.");
            }

            public void powerDown(BuildListener buildListener) {
                buildListener.getLogger().println("[VMware] Post-build for " + this.cfg.getVmxFilePath() + " on " + this.cfg.getHost() + "...");
                while (System.currentTimeMillis() < this.powerTime + 10000L) {
                    buildListener.getLogger().println("[VMware] Ensuring VM has completed BIOS boot sequence...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                switch (this.cfg.getPowerDownMode()) {
                    case CREATE_POWER_OFF: {
                        buildListener.getLogger().println("[VMware] Taking snapshot.");
                        this.vm.createSnapshot("", "", true);
                        break;
                    }
                }
                switch (this.cfg.getPowerDownMode()) {
                    case SUSPEND: 
                    case CREATE_SUSPEND: {
                        buildListener.getLogger().println("[VMware] Suspending virtual machine.");
                        this.vm.suspend();
                        break;
                    }
                    case CREATE_POWER_OFF: 
                    case NORMAL: 
                    case CREATE_NORMAL: {
                        buildListener.getLogger().println("[VMware] Powering off virtual machine.");
                        this.vm.powerOff();
                        break;
                    }
                }
                switch (this.cfg.getPowerDownMode()) {
                    case CREATE_SUSPEND: {
                        buildListener.getLogger().println("[VMware] Taking snapshot.");
                        this.vm.createSnapshot("", "", true);
                        break;
                    }
                    case CREATE_NORMAL: {
                        buildListener.getLogger().println("[VMware] Taking snapshot.");
                        this.vm.createSnapshot("", "", false);
                        break;
                    }
                }
                this.vm.close();
                buildListener.getLogger().println("[VMware] Disconnecting");
                this.host.disconnect();
                buildListener.getLogger().println("[VMware] Done");
                buildListener.getLogger().println("[VMware] Post-build for " + this.cfg.getVmxFilePath() + " on " + this.cfg.getHost() + " completed.");
            }
        }
        ArrayList<VMC> vms = new ArrayList<VMC>();
        try {
            VMware library = null;
            String lastLibrary = null;
            for (VMActivationConfig machine : this.machines) {
                VMwareHostConfig config = machine.getHostConfig();
                if (lastLibrary == null || !lastLibrary.equals(config.getVixLibraryPath())) {
                    lastLibrary = config.getVixLibraryPath();
                    library = new VMware(lastLibrary);
                }
                buildListener.getLogger().println("[VMware] Connecting to VMware Server host " + config.getHostName() + ":" + config.getPortNumber() + " as user " + config.getUsername());
                Host host = library.connect(config.getHostType(), config.getHostName(), config.getPortNumber(), config.getUsername(), config.getPassword());
                try {
                    buildListener.getLogger().println("[VMware] Opening virtual machine: " + machine.getVmxFilePath());
                    VirtualMachine vm = host.open(machine.getVmxFilePath());
                    try {
                        VMC vmc = new VMC(vm, host, machine);
                        vmc.powerUp(buildListener);
                        vms.add(vmc);
                    }
                    catch (VMwareRuntimeException e) {
                        vm.close();
                        throw e;
                    }
                }
                catch (VMwareRuntimeException e) {
                    host.disconnect();
                    throw e;
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class EnvironmentImpl
                    extends BuildWrapper.Environment {
                        private final List<VMC> vms;

                        public EnvironmentImpl(List<VMC> vms) {
                            super((BuildWrapper)VMwareActivationWrapper.this);
                            this.vms = vms;
                        }

                        public boolean tearDown(Build build, BuildListener buildListener) throws IOException, InterruptedException {
                            for (VMC vm : this.vms) {
                                vm.powerDown(buildListener);
                            }
                            return true;
                        }
                    }
                    return new EnvironmentImpl(vms);
                }
            }
        }
        catch (VMwareRuntimeException e) {
            buildListener.getLogger().println("[VMware] VMware VIX error: " + e.getMessage());
            e.printStackTrace(buildListener.getLogger());
            build.setResult(Result.FAILURE);
            for (VMC vmc : vms) {
                vmc.powerDown(buildListener);
            }
            return null;
        }
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public ResourceList getResourceList() {
        ResourceList resources = new ResourceList();
        for (VMActivationConfig machine : this.machines) {
            resources.w(new Resource(machine.getHost() + "/" + machine.getVmxFilePath()));
        }
        return resources;
    }

    public String getDisplayName() {
        return DESCRIPTOR.getDisplayName();
    }

    public static final class VMActivationConfig
    implements Serializable {
        private String vmxFilePath;
        private String host;
        private transient VMwareHostConfig hostConfig;
        private VMWrapperPowerUpMode powerUpMode;
        private VMWrapperPowerDownMode powerDownMode;
        private int waitTimeout;

        public int getWaitTimeout() {
            return this.waitTimeout <= 0 ? 300 : this.waitTimeout;
        }

        public void setWaitTimeout(int waitTimeout) {
            this.waitTimeout = waitTimeout;
        }

        public String getVmxFilePath() {
            return this.vmxFilePath;
        }

        public void setVmxFilePath(String vmxFilePath) {
            this.vmxFilePath = vmxFilePath;
        }

        public VMwareHostConfig getHostConfig() {
            if (this.hostConfig == null && this.host != null && !"".equals(this.host)) {
                this.setHostConfig(DESCRIPTOR.getHost(this.host));
            }
            return this.hostConfig;
        }

        public void setHostConfig(VMwareHostConfig hostConfig) {
            this.hostConfig = hostConfig;
        }

        public VMWrapperPowerUpMode getPowerUpMode() {
            return this.powerUpMode;
        }

        public void setPowerUpMode(VMWrapperPowerUpMode powerUpMode) {
            this.powerUpMode = powerUpMode;
        }

        public VMWrapperPowerDownMode getPowerDownMode() {
            return this.powerDownMode;
        }

        public void setPowerDownMode(VMWrapperPowerDownMode powerDownMode) {
            this.powerDownMode = powerDownMode;
        }

        public String getPreBuild() {
            return this.powerUpMode == null ? null : this.powerUpMode.toString();
        }

        public void setPreBuild(String powerUpMode) {
            this.powerUpMode = VMWrapperPowerUpMode.valueOf(powerUpMode);
        }

        public String getPostBuild() {
            return this.powerDownMode == null ? null : this.powerDownMode.toString();
        }

        public void setPostBuild(String powerDownMode) {
            this.powerDownMode = VMWrapperPowerDownMode.valueOf(powerDownMode);
        }

        public String getHost() {
            if (this.hostConfig == null) {
                return this.host;
            }
            this.host = this.hostConfig.getName();
            return this.host;
        }

        public void setHost(String name) {
            this.host = name;
            this.setHostConfig(DESCRIPTOR.getHost(this.host));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VMWrapperPowerDownMode implements Serializable
    {
        NORMAL("Power off"),
        SUSPEND("Suspend"),
        CREATE_POWER_OFF("Take snapshot before power off"),
        CREATE_NORMAL("Take snapshot after power off"),
        CREATE_SUSPEND("Take snapshot after suspend"),
        NOTHING("Do nothing");

        private String description;

        private VMWrapperPowerDownMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VMWrapperPowerUpMode implements Serializable
    {
        NORMAL_WAIT("Power up and wait for VMware Tools to start"),
        REVERT_WAIT("Revert to last snapshot, power up and wait for VMware Tools to start"),
        NORMAL("Power up (VMware Tools not installed)"),
        REVERT("Revert to last snapshot and power up (VMware Tools not installed)"),
        NOTHING("Do nothing");

        private String description;

        private VMWrapperPowerUpMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class VMwareHostConfig
    implements Serializable {
        public String name;
        public String vixLibraryPath;
        public String hostName;
        public int portNumber;
        public Host.HostType hostType;
        public String username;
        public String password;

        public VMwareHostConfig() {
        }

        public VMwareHostConfig(boolean dummy) {
            this.name = "(default)";
            this.hostType = Host.HostType.VMWARE_SERVER;
            this.portNumber = 902;
            this.vixLibraryPath = DESCRIPTOR.findDefaultVixLibraryPath();
            this.hostName = "";
            this.username = "";
            this.password = "";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public VMwareHostConfig(String vixLibraryPath, String hostName, int portNumber, Host.HostType hostType, String username, String password) {
            this.vixLibraryPath = vixLibraryPath;
            this.hostName = hostName;
            this.portNumber = portNumber;
            this.hostType = hostType;
            this.username = username;
            this.password = password;
        }

        public String getVixLibraryPath() {
            return this.vixLibraryPath == null || "".equals(this.vixLibraryPath) ? DESCRIPTOR.findDefaultVixLibraryPath() : this.vixLibraryPath;
        }

        public void setVixLibraryPath(String vixLibraryPath) {
            this.vixLibraryPath = vixLibraryPath;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public int getPortNumber() {
            if (this.portNumber == 0) {
                this.portNumber = 902;
            }
            return this.portNumber;
        }

        public void setPortNumber(int portNumber) {
            this.portNumber = portNumber == 0 ? 902 : portNumber;
        }

        public Host.HostType getHostType() {
            return this.hostType == null ? Host.HostType.VMWARE_SERVER : this.hostType;
        }

        public void setHostType(Host.HostType hostType) {
            this.hostType = hostType;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VMwareHostConfig that = (VMwareHostConfig)o;
            if (this.portNumber != that.portNumber) {
                return false;
            }
            if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
                return false;
            }
            if (this.hostType != that.hostType) {
                return false;
            }
            if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
                return false;
            }
            return !(this.vixLibraryPath != null ? !this.vixLibraryPath.equals(that.vixLibraryPath) : that.vixLibraryPath != null);
        }

        public int hashCode() {
            int result = this.vixLibraryPath != null ? this.vixLibraryPath.hashCode() : 0;
            result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
            result = 31 * result + this.portNumber;
            result = 31 * result + (this.hostType != null ? this.hostType.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        private List<VMwareHostConfig> hosts;

        DescriptorImpl() {
            super(VMwareActivationWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return "VMware Server VIX Virtual Machine Activation";
        }

        public VMwareActivationWrapper newInstance(StaplerRequest req) throws Descriptor.FormException {
            VMwareActivationWrapper w = new VMwareActivationWrapper();
            req.bindParameters((Object)w, "vmware-activation.");
            w.setMachines(req.bindParametersToList(VMActivationConfig.class, "vmware-activation.machine."));
            return w;
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            req.bindParameters((Object)this, "vmware.");
            this.hosts = req.bindParametersToList(VMwareHostConfig.class, "vmware.host.");
            this.save();
            return super.configure(req);
        }

        public List<VMwareHostConfig> getHosts() {
            if (this.hosts == null) {
                this.hosts = new ArrayList<VMwareHostConfig>();
                this.hosts.add(new VMwareHostConfig(true));
            }
            return this.hosts;
        }

        public void setHosts(List<VMwareHostConfig> hosts) {
            this.hosts = hosts;
        }

        public VMwareHostConfig getHost(String name) {
            for (VMwareHostConfig host : this.hosts) {
                if (!name.equals(host.getName())) continue;
                return host;
            }
            return null;
        }

        public String[] getHostNames() {
            String[] result = new String[this.hosts.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.hosts.get(i).getName();
            }
            return result;
        }

        public void addHost(VMwareHostConfig hostConfig) {
            this.hosts.add(hostConfig);
            this.save();
        }

        public String findDefaultVixLibraryPath() {
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                if (new File("C:\\Program Files\\VMware\\VMware VIX\\server-1\\32bit\\vix.dll").exists()) {
                    return "C:\\Program Files\\VMware\\VMware VIX\\server-1\\32bit";
                }
                if (new File("C:\\Program Files\\VMware\\VMware VIX\\vix.dll").exists()) {
                    return "C:\\Program Files\\VMware\\VMware VIX";
                }
                return "";
            }
            if (new File("/usr/lib/vmware-vix/lib/server-1/32bit/libvix.so").exists()) {
                return "/usr/lib/vmware-vix/lib/server-1/32bit";
            }
            if (new File("/usr/lib/vmware-vix/lib/libvix.so").exists()) {
                return "/usr/lib/vmware-vix/lib";
            }
            return "";
        }

        public VMWrapperPowerUpMode[] getPowerUpModes() {
            return VMWrapperPowerUpMode.values();
        }

        public VMWrapperPowerDownMode[] getPowerDownModes() {
            return VMWrapperPowerDownMode.values();
        }
    }
}

