/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import com.sun.jna.ptr.IntByReference;
import hudson.plugins.vmware.Host;
import hudson.plugins.vmware.VMware;
import hudson.plugins.vmware.VMwareRuntimeException;
import java.util.logging.Logger;

public class VirtualMachine {
    private static final Logger LOGGER = Logger.getLogger(Host.class.getName());
    private int handle = 0;
    private final VMware lib;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualMachine(VMware library, int hostHandle, String configFileHostPath) {
        this.lib = library;
        int jobHandle = 0;
        try {
            LOGGER.info("Trying to open virtual machine " + configFileHostPath);
            jobHandle = this.lib.getInstance().VixVM_Open(hostHandle, configFileHostPath, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.handle = this.lib.waitForJobAndGetJobResultHandle(jobHandle);
            LOGGER.info("Opened");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    public void close() {
        this.lib.getInstance().Vix_ReleaseHandle(this.handle);
        this.handle = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOn() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Powering up virtual machine");
            jobHandle = this.lib.getInstance().VixVM_PowerOn(this.handle, 0, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Powered up");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOff() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Powering off virtual machine");
            jobHandle = this.lib.getInstance().VixVM_PowerOff(this.handle, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Powered down");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Powering off virtual machine");
            jobHandle = this.lib.getInstance().VixVM_Suspend(this.handle, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Powered down");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Powering off virtual machine");
            jobHandle = this.lib.getInstance().VixVM_Reset(this.handle, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Powered down");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForToolsInGuest(int timeoutInSeconds) {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Waiting for Tools to start in guest");
            jobHandle = this.lib.getInstance().VixVM_WaitForToolsInGuest(this.handle, timeoutInSeconds, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Tools started in guest");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guestLogin(String username, String password) {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Login...");
            jobHandle = this.lib.getInstance().VixVM_LoginInGuest(this.handle, username, password, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Login OK");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    public void guestLoginAnonymous() {
        this.guestLogin("__VMware_Vix_Guest_User_Anonymous__", null);
    }

    public void guestLoginAdministrator() {
        this.guestLogin("__VMware_Vix_Guest_User_Admin__", null);
    }

    public void guestLoginConsole() {
        this.guestLogin("__VMware_Vix_Guest_Console_User__", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guestLogout() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Logout...");
            jobHandle = this.lib.getInstance().VixVM_LogoutFromGuest(this.handle, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Logout OK");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int guestExec(String execGuestPath, String args, boolean wait, boolean activateWindow) {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info(wait ? "Executing process in guest" : "Spawning process in guest");
            jobHandle = this.lib.getInstance().VixVM_RunProgramInGuest(this.handle, execGuestPath, args, (wait ? 0 : 1) + (activateWindow ? 2 : 0), 0, null, null);
            LOGGER.fine("Waiting...");
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Exec OK");
            IntByReference exitCode = new IntByReference();
            this.lib.checkError(this.lib.getInstance().Vix_GetProperties(jobHandle, 3018, exitCode, 0));
            int n = exitCode.getValue();
            return n;
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    public int guestExec(String execGuestPath, String args, boolean wait) {
        return this.guestExec(execGuestPath, args, wait, false);
    }

    public int guestExec(String execGuestPath, String args) {
        return this.guestExec(execGuestPath, args, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guestOpenUrl(String url) {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Open URL in guest");
            jobHandle = this.lib.getInstance().VixVM_OpenUrlInGuest(this.handle, url, 0, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Url opened OK");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSnapshot(String name, String description, boolean includeMemory) {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Creating snapshot");
            jobHandle = this.lib.getInstance().VixVM_CreateSnapshot(this.handle, name, description, includeMemory ? 2 : 0, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Created snapshot OK");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSnapshot() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Removing snapshot");
            IntByReference snapshotHandle = new IntByReference();
            this.lib.checkError(this.lib.getInstance().VixVM_GetRootSnapshot(this.handle, 0, snapshotHandle));
            jobHandle = this.lib.getInstance().VixVM_RemoveSnapshot(this.handle, snapshotHandle.getValue(), 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Removed snapshot OK");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertToSnapshot() {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        int jobHandle = 0;
        try {
            LOGGER.info("Reverting to snapshot");
            IntByReference snapshotHandle = new IntByReference();
            this.lib.checkError(this.lib.getInstance().VixVM_GetRootSnapshot(this.handle, 0, snapshotHandle));
            jobHandle = this.lib.getInstance().VixVM_RevertToSnapshot(this.handle, snapshotHandle.getValue(), 0, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting...");
            this.lib.waitForJob(jobHandle);
            LOGGER.info("Revert to snapshot OK");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }
}

