/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import hudson.Plugin;
import hudson.plugins.vmware.VMwareActivationWrapper;
import hudson.tasks.BuildWrappers;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    private static final ConcurrentMap<String, String> vmIPAddresses = new ConcurrentHashMap<String, String>();
    private final String URL_PREFIX = "file:/";
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());

    public void start() throws Exception {
        BuildWrappers.WRAPPERS.add(VMwareActivationWrapper.DESCRIPTOR);
    }

    public void doVixLibraryCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new FormFieldValidator(req, rsp, true){

            public void check() throws IOException, ServletException {
                File f = this.getFileParameter("value");
                if (!f.isDirectory()) {
                    this.error(f + " is not a directory");
                    return;
                }
                File winDll = new File(f, "vix.dll");
                File linuxSO = new File(f, "libvix.so");
                if (!winDll.exists() && !linuxSO.exists()) {
                    this.error(f + " doesn't look like a VIX library directory");
                    return;
                }
                this.ok();
            }
        }.process();
    }

    public Map<String, String> getVmIPAddresses() {
        return Collections.unmodifiableMap(vmIPAddresses);
    }

    public void doSet(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String ip;
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        String key = req.getParameter("name");
        String ip1 = req.getParameter("override");
        String ip2 = req.getRemoteAddr();
        String string = ip = ip1 == null ? ip2 : ip1;
        if (key == null) {
            w.append("Must provide the 'name' parameter.\n");
            w.append("If the request is being forwarded through a proxy, the IP address to use can be set using the 'override' parameter.\n");
        } else {
            w.append(key + "=" + ip + "\n");
            PluginImpl.setVMIP(key, ip);
        }
        w.append("Request originated from " + ip2 + ".");
        w.close();
    }

    public void doUnset(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        String key = req.getParameter("name");
        if (key == null) {
            w.append("Must provide the 'name' parameter.\n");
        } else {
            w.append(key + " cleared.\n");
            PluginImpl.clearVMIP(key);
        }
        w.append("Request originated from " + req.getRemoteAddr() + ".");
        w.close();
    }

    public void doQuery(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        String key = req.getParameter("name");
        if (key == null) {
            w.append("Must provide the 'name' parameter.\n");
        } else {
            w.append(PluginImpl.getVMIP(key));
        }
        w.close();
    }

    public static void setVMIP(String key, String ip) {
        vmIPAddresses.put(key, ip);
    }

    public static void clearVMIP(String key) {
        vmIPAddresses.remove(key);
    }

    public static String getVMIP(String key) {
        return (String)vmIPAddresses.get(key);
    }

    public static Set<String> getVMs() {
        return Collections.unmodifiableSet(vmIPAddresses.keySet());
    }
}

