/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import hudson.Plugin;
import hudson.plugins.vmware.VMwareActivationWrapper;
import hudson.tasks.BuildWrappers;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PluginImpl
extends Plugin {
    private static final ConcurrentMap<String, String> vmIPAddresses = new ConcurrentHashMap();
    private static final ConcurrentMap<String, CountDownLatch> nameLatches = new ConcurrentHashMap();
    private final String URL_PREFIX = "file:/";
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());

    public void start() throws Exception {
        BuildWrappers.WRAPPERS.add(VMwareActivationWrapper.DESCRIPTOR);
    }

    public void doVixLibraryCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new /* Unavailable Anonymous Inner Class!! */.process();
    }

    public Map<String, String> getVmIPAddresses() {
        return Collections.unmodifiableMap(vmIPAddresses);
    }

    public void doSet(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String ip;
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        String key = req.getParameter("name");
        String ip1 = req.getParameter("override");
        String ip2 = req.getRemoteAddr();
        String string = ip = ip1 == null ? ip2 : ip1;
        if (key == null) {
            w.append("Must provide the 'name' parameter.\n");
            w.append("If the request is being forwarded through a proxy, the IP address to use can be set using the 'override' parameter.\n");
        } else {
            w.append(key + "=" + ip + "\n");
            PluginImpl.setVMIP((String)key, (String)ip);
        }
        w.append("Request originated from " + ip2 + ".");
        w.close();
    }

    public void doUnset(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        String key = req.getParameter("name");
        if (key == null) {
            w.append("Must provide the 'name' parameter.\n");
        } else {
            w.append(key + " cleared.\n");
            PluginImpl.clearVMIP((String)key);
        }
        w.append("Request originated from " + req.getRemoteAddr() + ".");
        w.close();
    }

    public void doQuery(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        String key = req.getParameter("name");
        if (key == null) {
            w.append("Must provide the 'name' parameter.\n");
        } else {
            w.append(PluginImpl.getVMIP((String)key));
        }
        w.close();
    }

    public static void awaitVMIP(String key) throws InterruptedException {
        if (vmIPAddresses.containsKey(key)) {
            return;
        }
        PluginImpl.watchVMIP((String)key);
        CountDownLatch latch = (CountDownLatch)nameLatches.get(key);
        assert (latch != null);
        latch.await();
    }

    public static boolean awaitVMIP(String key, long timeout, TimeUnit unit) throws InterruptedException {
        if (vmIPAddresses.containsKey(key)) {
            return true;
        }
        PluginImpl.watchVMIP((String)key);
        CountDownLatch latch = (CountDownLatch)nameLatches.get(key);
        assert (latch != null);
        return latch.await(timeout, unit);
    }

    public static void watchVMIP(String key) {
        if (!nameLatches.containsKey(key)) {
            nameLatches.putIfAbsent(key, new CountDownLatch(1));
        }
    }

    public static void setVMIP(String key, String ip) {
        vmIPAddresses.put(key, ip);
        CountDownLatch latch = (CountDownLatch)nameLatches.get(key);
        if (latch != null) {
            latch.countDown();
            nameLatches.remove(key, latch);
        }
    }

    public static void clearVMIP(String key) {
        vmIPAddresses.remove(key);
    }

    public static String getVMIP(String key) {
        return (String)vmIPAddresses.get(key);
    }

    public static Set<String> getVMs() {
        return Collections.unmodifiableSet(vmIPAddresses.keySet());
    }
}

