/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmware;

import hudson.plugins.vmware.VMware;
import hudson.plugins.vmware.VMwareRuntimeException;
import hudson.plugins.vmware.VirtualMachine;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Host {
    private static final Logger LOGGER = Logger.getLogger(Host.class.getName());
    private int handle = 0;
    private final VMware lib;
    private final AtomicInteger usageCount = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Host(VMware library, HostType hostType, String hostName, int hostPort, String userName, String password) {
        this.lib = library;
        LOGGER.info("Connecting to " + hostName);
        int jobHandle = 0;
        try {
            switch (hostType) {
                default: 
            }
            jobHandle = this.lib.getInstance().VixHost_Connect(1, 2, hostName, hostPort, userName, password, 0, 0, null, null);
            if (jobHandle == 0) {
                throw new VMwareRuntimeException("Unknown error");
            }
            LOGGER.fine("Waiting to connect...");
            this.handle = this.lib.waitForJobAndGetJobResultHandle(jobHandle);
            LOGGER.info("Connected");
        }
        finally {
            this.lib.getInstance().Vix_ReleaseHandle(jobHandle);
        }
    }

    public void disconnect() {
        if (this.usageCount.decrementAndGet() <= 0) {
            this.lib.getInstance().VixHost_Disconnect(this.handle);
            this.handle = 0;
        }
    }

    public VirtualMachine open(String configFileHostPath) {
        if (this.handle == 0 || this.lib == null) {
            throw new VMwareRuntimeException("Not connected.");
        }
        VirtualMachine machine = new VirtualMachine(this.lib, this.handle, configFileHostPath);
        this.usageCount.getAndIncrement();
        return machine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HostType {
        VMWARE_SERVER;

    }
}

