/*
 * Decompiled with CFR 0.152.
 */
package scm.vss;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;
import scm.vss.VSSSCM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSSChangeLogSet
extends ChangeLogSet<VSSChangeLog> {
    private List<VSSChangeLog> history = new ArrayList<VSSChangeLog>();

    public VSSChangeLogSet(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
        super(build);
        Digester digester = new Digester();
        digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        digester.push(this.history);
        digester.addObjectCreate("*/entry", VSSChangeLog.class);
        for (String tag : VSSSCM.TAGS) {
            digester.addBeanPropertySetter("*/entry/" + tag);
        }
        digester.addSetNext("*/entry", "add");
        digester.parse(changeLogFile);
    }

    public boolean isEmptySet() {
        return this.history.size() == 0;
    }

    public Iterator<VSSChangeLog> iterator() {
        return this.history.iterator();
    }

    public List getLogs() {
        return this.history;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VSSChangeLog
    extends ChangeLogSet.Entry {
        private static final int MAX_CHARS = 40;
        private String user = null;
        private String version = null;
        private String action = null;
        private String date = null;
        private String comment = null;
        private String file = null;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public User getAuthor() {
            return User.get((String)this.user);
        }

        public String getMsg() {
            StringBuffer buffer = new StringBuffer();
            VSSChangeLog.filterFromEnd(this.getFile(), buffer);
            buffer.append(" - ");
            VSSChangeLog.filterFromStart(this.getComment(), buffer);
            return buffer.toString();
        }

        private static void filterFromStart(String string, StringBuffer buffer) {
            VSSChangeLog.filter(string, 40, buffer, 0, string.length(), 1);
        }

        private static void filterFromEnd(String string, StringBuffer buffer) {
            VSSChangeLog.filter(string, 40, buffer, string.length() - 1, -1, -1);
            buffer.reverse();
        }

        private static void filter(String string, int maxchar, StringBuffer buffer, int start, int end, int incr) {
            int index = start;
            while (index != end) {
                if (maxchar == 0 || string.charAt(index) == '\n') {
                    buffer.append("...");
                    break;
                }
                buffer.append(string.charAt(index));
                index += incr;
                --maxchar;
            }
        }

        public Collection<String> getAffectedPaths() {
            return Collections.singletonList(this.file);
        }
    }
}

