/*
 * Decompiled with CFR 0.152.
 */
package scm.vss;

import com4j.Com4jObject;
import com4j.Holder;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.StaplerRequest;
import org.xml.sax.SAXException;
import scm.vss.VSSChangeLogSet;
import vss.ClassFactory;
import vss.IVSSDatabase;
import vss.IVSSItem;
import vss.IVSSItems;
import vss.IVSSVersion;
import vss.IVSSVersions;
import vss.VSSFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSSSCM
extends SCM {
    private static final int MAX_HISTORY_ENTRIES = 100;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    static final String[] TAGS = new String[]{"file", "user", "comment", "action", "date", "version"};
    private static final String DELETED_ACTION = "Deleted";
    private static final String DESTROYED_ACTION = "Destroyed";
    private static final String ADDED_ACTION = "Added";
    private static final String RECOVERED_ACTION = "Recovered";
    private String serverPath = null;
    private String user = null;
    private String password = null;
    private String vssPath = null;
    private boolean isWritable = false;
    private boolean isRecursive = true;
    private boolean useUpdate = false;

    public VSSSCM(String serverPath, String user, String password, String vssPath, boolean isWritable, boolean isRecursive, boolean useUpdate) {
        this.serverPath = serverPath;
        this.user = user;
        this.password = password;
        this.vssPath = vssPath;
        this.isWritable = isWritable;
        this.isRecursive = isRecursive;
        this.useUpdate = useUpdate;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return workspace;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        Build lastBuild = (Build)project.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Date buildTime = lastBuild.getTimestamp().getTime();
        return this.getHistoryEntries(buildTime, 1, null).size() != 0;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List<Object[]> historyEntries;
        if (launcher.isUnix()) {
            listener.getLogger().println("Visual SourceSafe support only runs on Windows");
            return false;
        }
        ArrayList<String> deletions = null;
        AbstractBuild lastBuild = (AbstractBuild)build.getPreviousBuild();
        if (lastBuild == null) {
            historyEntries = this.getHistoryEntries(new Date(0L), null);
        } else {
            Date buildTime;
            if (this.useUpdate) {
                deletions = new ArrayList<String>();
            }
            if ((historyEntries = this.getHistoryEntries(buildTime = lastBuild.getTimestamp().getTime(), deletions)).size() >= 100) {
                deletions = null;
            }
        }
        if (deletions != null) {
            this.delete(new File(workspace.toURI()), deletions);
        } else {
            workspace.deleteContents();
        }
        this.get(new File(workspace.toURI()).getAbsolutePath());
        this.save(changelogFile, historyEntries);
        return true;
    }

    private List<Object[]> getHistoryEntries(Date startDate, List<String> deletions) throws IOException {
        return this.getHistoryEntries(startDate, 100, deletions);
    }

    private List<Object[]> getHistoryEntries(Date startDate, int maxEntries, List<String> deletions) throws IOException {
        try {
            Com4jObject object;
            if (!new File(this.serverPath).exists()) {
                throw new IOException(this.serverPath + " doesn't exist. Configuration error?");
            }
            if (new File(this.serverPath).isDirectory()) {
                throw new IOException(this.serverPath + " is a directory. Please specify the location of srcsafe.ini");
            }
            IVSSDatabase database = ClassFactory.createVSSDatabase();
            database.open(this.serverPath, this.user, this.password);
            IVSSItem vssItem = database.vssItem(this.vssPath, false);
            int vssLength = vssItem.spec().length();
            int flag = this.isRecursive ? VSSFlags.VSSFLAG_RECURSYES.comEnumValue() : VSSFlags.VSSFLAG_RECURSNO.comEnumValue();
            IVSSVersions versions = vssItem.versions(flag);
            ArrayList<Object[]> historyEntries = new ArrayList<Object[]>();
            Iterator iterator = versions.iterator();
            for (int historyCount = 0; historyCount < maxEntries && iterator.hasNext(); ++historyCount) {
                object = (Com4jObject)iterator.next();
                IVSSVersion version = (IVSSVersion)object.queryInterface(IVSSVersion.class);
                Date historyDate = version.date();
                if (historyDate.before(startDate)) {
                    version.dispose();
                    object.dispose();
                    break;
                }
                int versionNo = version.versionNumber();
                IVSSItem historyItem = version.vssItem();
                Object[] content = new Object[]{historyItem.spec(), version.username(), version.comment(), version.action().trim(), DATE_FORMAT.format(version.date()), Integer.toString(versionNo)};
                if (versionNo != 1 && (DELETED_ACTION.equals(content[3]) || DESTROYED_ACTION.equals(content[3]) || ADDED_ACTION.equals(content[3]) || RECOVERED_ACTION.equals(content[3]))) {
                    IVSSItem preItem = historyItem.version((Object)(versionNo - 1));
                    Set post = this.collectItems(historyItem);
                    Set pre = this.collectItems(preItem);
                    preItem.dispose();
                    if (ADDED_ACTION.equals(content[3]) || RECOVERED_ACTION.equals(content[3])) {
                        post.removeAll(pre);
                    } else {
                        pre.removeAll(post);
                        post = pre;
                    }
                    Iterator chgIterator = post.iterator();
                    if (chgIterator.hasNext()) {
                        content[0] = chgIterator.next();
                    }
                }
                if (deletions != null && (DELETED_ACTION.equals(content[3]) || RECOVERED_ACTION.equals(content[3]))) {
                    deletions.add(((String)content[0]).substring(vssLength));
                }
                historyItem.dispose();
                version.dispose();
                object.dispose();
                historyEntries.add(content);
            }
            while (iterator.hasNext()) {
                object = (Com4jObject)iterator.next();
                object.dispose();
            }
            versions.dispose();
            vssItem.dispose();
            database.dispose();
            return historyEntries;
        }
        catch (RuntimeException error) {
            throw new IOException2((Throwable)error);
        }
    }

    private void save(File file, List<Object[]> history) throws IOException {
        PrintStream stream = new PrintStream(new FileOutputStream(file));
        int size = history.size();
        int tagcount = TAGS.length;
        stream.println("<history>");
        for (int index = 0; index < size; ++index) {
            stream.println("\t<entry>");
            Object[] entry = history.get(index);
            for (int tag = 0; tag < tagcount; ++tag) {
                stream.print("\t\t<");
                stream.print(TAGS[tag]);
                stream.print('>');
                stream.print(VSSSCM.escapeForXml(entry[tag]));
                stream.print("</");
                stream.print(TAGS[tag]);
                stream.println('>');
            }
            stream.println("\t</entry>");
        }
        stream.println("</history>");
        stream.close();
    }

    private void get(String localPath) throws IOException {
        try {
            IVSSDatabase database = ClassFactory.createVSSDatabase();
            database.open(this.serverPath, this.user, this.password);
            IVSSItem vssItem = database.vssItem(this.vssPath, false);
            int flags = VSSFlags.VSSFLAG_FORCEDIRNO.comEnumValue();
            flags = this.isWritable ? (flags |= VSSFlags.VSSFLAG_USERRONO.comEnumValue()) : (flags |= VSSFlags.VSSFLAG_USERROYES.comEnumValue());
            flags = this.isRecursive ? (flags |= VSSFlags.VSSFLAG_RECURSYES.comEnumValue()) : (flags |= VSSFlags.VSSFLAG_RECURSNO.comEnumValue());
            vssItem.get(new Holder((Object)localPath), flags);
            vssItem.dispose();
            database.dispose();
        }
        catch (RuntimeException error) {
            throw new IOException2((Throwable)error);
        }
    }

    private void delete(File workspace, List<String> deletions) {
        for (String deletion : deletions) {
            File file = new File(workspace, deletion);
            if (!file.exists()) continue;
            try {
                Util.deleteRecursive((File)file);
            }
            catch (IOException e) {}
        }
    }

    public static String escapeForXml(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        int size = string.length();
        StringBuilder escapedString = new StringBuilder(size);
        block7: for (int index = 0; index < size; ++index) {
            char ch = string.charAt(index);
            switch (ch) {
                case '&': {
                    escapedString.append("&amp;");
                    continue block7;
                }
                case '<': {
                    escapedString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedString.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    escapedString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    escapedString.append("&quot;");
                    continue block7;
                }
                default: {
                    escapedString.append(ch);
                }
            }
        }
        return escapedString.toString();
    }

    private Set collectItems(IVSSItem folder) {
        IVSSItems items = folder.items(false);
        Iterator iterator = items.iterator();
        HashSet<String> itemSet = new HashSet<String>(items.count());
        while (iterator.hasNext()) {
            Com4jObject object = (Com4jObject)iterator.next();
            IVSSItem item = (IVSSItem)object.queryInterface(IVSSItem.class);
            itemSet.add(item.spec());
        }
        return itemSet;
    }

    public ChangeLogParser createChangeLogParser() {
        return new VSSChangeLogParser();
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public String getUser() {
        return this.user;
    }

    public String getVssPath() {
        return this.vssPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VSSDescriptor
    extends SCMDescriptor<VSSSCM> {
        public VSSDescriptor() {
            super(VSSSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "Visual Source Safe";
        }

        public VSSSCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new VSSSCM(req.getParameter("server_path"), req.getParameter("user"), req.getParameter("password"), req.getParameter("vss_path"), req.getParameter("writable") != null, req.getParameter("recursive") != null, req.getParameter("useupdate") != null);
        }
    }

    private static class VSSChangeLogParser
    extends ChangeLogParser {
        private VSSChangeLogParser() {
        }

        public VSSChangeLogSet parse(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
            return new VSSChangeLogSet(build, changeLogFile);
        }
    }
}

