/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.warnings.util.model.AbstractAnnotation;
import hudson.plugins.warnings.util.model.Priority;
import org.apache.commons.lang.StringUtils;

public class Warning
extends AbstractAnnotation {
    private static final long serialVersionUID = 5171661552905752370L;
    private final String type;
    private final String category;

    public Warning(String fileName, int start, String type, String category, String message) {
        this(fileName, start, type, category, message, Priority.NORMAL);
    }

    public Warning(String fileName, int start, String type, String category, String message, Priority priority) {
        super(priority, message, start, start);
        this.type = type;
        this.category = category;
        this.setFileName(fileName);
    }

    public String getShortFileName() {
        return StringUtils.substringAfterLast((String)this.getFileName(), (String)"/");
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getToolTip() {
        return this.getMessage();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.category == null ? 0 : this.category.hashCode());
        result = prime * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Warning other = (Warning)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

