/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util;

import hudson.plugins.warnings.util.FileInputStreamFactory;
import hudson.plugins.warnings.util.MavenModuleDetector;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public final class MavenModuleDetector {
    private FileInputStreamFactory factory = new DefaultFileInputStreamFactory(null);

    public void setFileInputStreamFactory(FileInputStreamFactory fileInputStreamFactory) {
        this.factory = fileInputStreamFactory;
    }

    public String guessModuleName(String fileName) {
        String unixName = fileName.replace("\\", "/");
        String module = this.checkPrefix(unixName, "/src");
        if (StringUtils.isNotBlank((String)module)) {
            return module;
        }
        module = this.checkPrefix(unixName, "/target");
        if (StringUtils.isNotBlank((String)module)) {
            return module;
        }
        return "";
    }

    private String checkPrefix(String file, String folder) {
        if (file.contains(folder)) {
            String module = StringUtils.substringBeforeLast((String)file, (String)folder);
            String projectName = this.parsePom(module);
            if (!StringUtils.isBlank((String)projectName)) {
                return projectName;
            }
            if (module.contains("/")) {
                module = StringUtils.substringAfterLast((String)module, (String)"/");
            }
            return module;
        }
        return "";
    }

    private String parsePom(String fileName) {
        try {
            InputStream pom = this.factory.create(fileName + "/pom.xml");
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(MavenModuleDetector.class.getClassLoader());
            digester.push((Object)new StringBuffer());
            digester.addCallMethod("project/name", "append", 0);
            StringBuffer result = (StringBuffer)digester.parse(pom);
            return result.toString();
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return "";
    }
}

