/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.util.model;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.warnings.util.model.AnnotationContainer;
import hudson.plugins.warnings.util.model.FileAnnotation;
import hudson.plugins.warnings.util.model.JavaPackage;
import hudson.plugins.warnings.util.model.WorkspaceFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModule
extends AnnotationContainer {
    private static final long serialVersionUID = 5467122420572804130L;
    private String name;
    @SuppressWarnings(value={"Se"})
    private final Map<String, JavaPackage> packageMapping = new HashMap();
    private String error;

    public MavenModule() {
    }

    public MavenModule(String moduleName) {
        super(false, moduleName);
    }

    private Object readResolve() {
        this.rebuildMappings(false);
        if (this.name != null) {
            this.setName(this.name);
        }
        return this;
    }

    protected void annotationAdded(FileAnnotation annotation) {
        String packageName = annotation.getPackageName();
        if (!this.packageMapping.containsKey(packageName)) {
            this.packageMapping.put(packageName, new JavaPackage(packageName));
        }
        ((JavaPackage)this.packageMapping.get(packageName)).addAnnotation(annotation);
    }

    public Collection<JavaPackage> getPackages() {
        return Collections.unmodifiableCollection(this.packageMapping.values());
    }

    public JavaPackage getPackage(String packageName) {
        JavaPackage javaPackage = (JavaPackage)this.packageMapping.get(packageName);
        if (javaPackage != null) {
            return javaPackage;
        }
        throw new NoSuchElementException("Package not found: " + packageName);
    }

    public Collection<WorkspaceFile> getFiles() {
        ArrayList<WorkspaceFile> files = new ArrayList<WorkspaceFile>();
        for (JavaPackage javaPackage : this.packageMapping.values()) {
            files.addAll(javaPackage.getFiles());
        }
        return files;
    }

    public WorkspaceFile getFile(String fileName) {
        if (this.packageMapping.size() != 1) {
            throw new IllegalArgumentException("Number of packages != 1");
        }
        return ((JavaPackage)this.packageMapping.values().iterator().next()).getFile(fileName);
    }

    public int getAnnotationBound() {
        int tasks = 0;
        for (JavaPackage javaPackage : this.packageMapping.values()) {
            tasks = Math.max(tasks, javaPackage.getNumberOfAnnotations());
        }
        return tasks;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }
}

